/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.resource;

import com.google.common.hash.Hashing;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.cursor.CursorType;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.config.Config;
import io.github.fishstiz.cursors_extended.config.CursorMetadata;
import io.github.fishstiz.cursors_extended.config.CursorProperties;
import io.github.fishstiz.cursors_extended.config.JsonLoader;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorRegistry;
import io.github.fishstiz.cursors_extended.lifecycle.ClientStartedListener;
import io.github.fishstiz.cursors_extended.resource.texture.AnimatedCursorTexture;
import io.github.fishstiz.cursors_extended.resource.texture.AnimationState;
import io.github.fishstiz.cursors_extended.resource.texture.BasicCursorTexture;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.NotNull;

public class CursorTextureLoader
implements PreparableReloadListener,
ClientStartedListener {
    private static final ResourceLocation DIRECTORY = CursorsExtended.loc("textures/gui/sprites/cursors");
    private final Map<String, CursorMetadata> preparedMetadata = new Object2ObjectOpenHashMap();
    private final CursorRegistry registry;
    private Minecraft minecraft;
    private boolean prepared;

    public CursorTextureLoader(CursorRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void onClientStarted(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    @NotNull
    public CompletableFuture<Void> reload(PreparableReloadListener.SharedState sharedState, Executor backgroundExecutor, PreparableReloadListener.PreparationBarrier preparationBarrier, Executor gameExecutor) {
        this.prepared = false;
        return CompletableFuture.runAsync(() -> this.prepare(sharedState.resourceManager()), backgroundExecutor).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0));
    }

    public void reload() {
        this.prepare(this.minecraft.getResourceManager());
        this.loadTextures(this.registry.getCursors());
    }

    private Optional<String> prepareMetadataHash(ResourceManager manager, Iterable<Cursor> hashableCursors) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (Cursor cursor : hashableCursors) {
            ResourceLocation path = CursorTextureLoader.getExpectedPath(cursor.cursorType());
            manager.getResource(path.withSuffix(".json")).ifPresentOrElse(resource -> {
                try {
                    CursorMetadata metadata = this.loadMetadata(manager, path, resource.sourcePackId());
                    this.preparedMetadata.put(cursor.name(), metadata);
                    out.write(resource.sourcePackId().getBytes(StandardCharsets.UTF_8));
                    CursorTextureLoader.writeBytes(out, metadata);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }, () -> this.preparedMetadata.put(cursor.name(), new CursorMetadata()));
        }
        return out.size() == 0 ? Optional.empty() : Optional.of(Hashing.murmur3_32_fixed().hashBytes(out.toByteArray()).toString());
    }

    private void prepare(ResourceManager manager) {
        this.preparedMetadata.clear();
        this.prepareMetadataHash(manager, this.registry.getInternalCursors()).ifPresentOrElse(hash -> {
            if (!Objects.equals(CursorsExtended.CONFIG.getHash(), hash)) {
                CursorsExtended.LOGGER.info("[cursors_extended] Resource pack hash has changed, updating config...");
                CursorsExtended.CONFIG.setHash((String)hash);
                CursorsExtended.CONFIG.getGlobal().setActiveAll(false);
                CursorsExtended.CONFIG.markSettingsStale();
            }
        }, () -> {
            CursorsExtended.LOGGER.info("[cursors_extended] No resource pack detected.");
            CursorsExtended.CONFIG.setHash("");
        });
        for (Cursor cursor : this.registry.getCursors()) {
            cursor.prepareReload();
            CursorMetadata metadata = this.preparedMetadata.computeIfAbsent(cursor.name(), type -> {
                ResourceLocation path = CursorTextureLoader.getExpectedPath(cursor.cursorType());
                return manager.getResource(path.withSuffix(".json")).map(resource -> this.loadMetadata(manager, path, resource.sourcePackId())).orElse(new CursorMetadata());
            });
            if (!CursorsExtended.CONFIG.isStale(cursor)) continue;
            CursorsExtended.CONFIG.getOrCreateSettings(cursor).mergeSelective(metadata.cursor());
        }
        this.prepared = true;
        CursorsExtended.CONFIG.save();
    }

    public void releaseTexture(Cursor cursor) {
        CursorTexture texture = cursor.getTexture();
        if (texture != null) {
            texture.close();
            cursor.setTexture(null);
            this.minecraft.execute(() -> this.minecraft.getTextureManager().release(texture.texturePath()));
        }
    }

    private boolean loadTexture(ResourceManager manager, Cursor cursor) {
        boolean loaded;
        block16: {
            if (!this.prepared) {
                return false;
            }
            ResourceLocation path = CursorTextureLoader.getExpectedPath(cursor.cursorType());
            loaded = false;
            try {
                Resource resource = manager.getResource(path).orElse(null);
                if (resource == null) break block16;
                try (InputStream in = resource.open();
                     NativeImage image = NativeImage.read((InputStream)in);){
                    SettingsUtil.assertImageSize(image.getWidth(), image.getHeight());
                    CursorMetadata metadata = this.preparedMetadata.getOrDefault(cursor.name(), this.loadMetadata(manager, path, resource.sourcePackId()));
                    Config.CursorSettings settings = CursorsExtended.CONFIG.getGlobal().apply(CursorsExtended.CONFIG.getOrCreateSettings(cursor));
                    CursorTexture texture = metadata.animation() != null ? new AnimatedCursorTexture(AnimationState.of(metadata.animation().mode()), image, path, metadata, settings) : new BasicCursorTexture(image, path, metadata, settings);
                    cursor.setTexture(texture);
                    this.minecraft.execute(() -> this.minecraft.getTextureManager().release(path));
                    loaded = true;
                }
            }
            catch (Exception e) {
                CursorsExtended.LOGGER.error("[cursors_extended] Failed to load cursor texture for '{}'. ", (Object)cursor.cursorType(), (Object)e);
            }
        }
        if (!loaded) {
            this.releaseTexture(cursor);
        }
        cursor.reloaded();
        return loaded;
    }

    public boolean loadTexture(Cursor cursor) {
        return this.loadTexture(this.minecraft.getResourceManager(), cursor);
    }

    private void loadTextures(ResourceManager manager, Collection<Cursor> cursors) {
        for (Cursor cursor : cursors) {
            this.loadTexture(manager, cursor);
        }
    }

    public void lazyLoadTexture(Cursor cursor) {
        if (cursor.isEnabled() && cursor.isLazy()) {
            this.loadTexture(cursor);
        }
    }

    public void loadTextures(Collection<Cursor> cursors) {
        this.loadTextures(this.minecraft.getResourceManager(), cursors);
    }

    public void updateTexture(Cursor cursor, float scale, int xhot, int yhot) {
        CursorTexture texture = cursor.getTexture();
        if (texture == null) {
            return;
        }
        Config.CursorSettings settings = CursorsExtended.CONFIG.getOrCreateSettings(cursor).copy();
        settings.setScale(scale);
        settings.setXHot(cursor, xhot);
        settings.setYHot(cursor, yhot);
        try {
            CursorTexture updatedTexture = texture.recreate(settings);
            cursor.setTexture(updatedTexture);
            texture.close();
        }
        catch (Exception e) {
            CursorsExtended.LOGGER.error("[cursors_extended] Failed to update texture of cursor '{}'.", (Object)cursor.cursorType(), (Object)e);
            cursor.setTexture(texture);
        }
    }

    public void updateTexture(Cursor cursor, CursorProperties settings) {
        this.updateTexture(cursor, settings.scale(), settings.xhot(), settings.yhot());
    }

    private CursorMetadata loadMetadata(ResourceManager manager, ResourceLocation location, String source) {
        return manager.getResourceStack(location.withSuffix(".json")).stream().filter(metadata -> metadata.sourcePackId().equals(source)).findFirst().map(metadata -> JsonLoader.fromResource(CursorMetadata.class, metadata)).orElse(new CursorMetadata());
    }

    private static void writeBytes(ByteArrayOutputStream out, CursorMetadata metadata) throws IOException {
        CursorMetadata.Animation anim;
        CursorMetadata.CursorSettings cs = metadata.cursor();
        out.write(Float.toString(cs.scale()).getBytes(StandardCharsets.UTF_8));
        out.write(Integer.toString(cs.xhot()).getBytes(StandardCharsets.UTF_8));
        out.write(Integer.toString(cs.yhot()).getBytes(StandardCharsets.UTF_8));
        out.write(Boolean.toString(cs.enabled()).getBytes(StandardCharsets.UTF_8));
        if (cs.animated() != null) {
            out.write(Boolean.toString(cs.animated()).getBytes(StandardCharsets.UTF_8));
        }
        if ((anim = metadata.animation()) != null) {
            out.write(anim.mode().name().getBytes(StandardCharsets.UTF_8));
            out.write(Integer.toString(anim.frametime()).getBytes(StandardCharsets.UTF_8));
            if (anim.width() != null) {
                out.write(Integer.toString(anim.width()).getBytes(StandardCharsets.UTF_8));
            }
            if (anim.height() != null) {
                out.write(Integer.toString(anim.height()).getBytes(StandardCharsets.UTF_8));
            }
            for (CursorMetadata.Animation.Frame f : anim.frames()) {
                out.write(Integer.toString(f.index()).getBytes(StandardCharsets.UTF_8));
                out.write(Integer.toString(f.clampedTime(anim)).getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    private static ResourceLocation getExpectedPath(CursorType cursorType) {
        return DIRECTORY.withSuffix("/" + cursorType.toString() + ".png");
    }

    public static ResourceLocation getDir() {
        return DIRECTORY;
    }
}

