/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.screen.panel;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorTypesExt;
import io.github.fishstiz.cursors_extended.gui.screen.panel.AbstractOptionsPanel;
import io.github.fishstiz.cursors_extended.gui.widget.OptionsListWidget;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import io.github.fishstiz.cursors_extended.util.DrawUtil;
import java.util.function.Consumer;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import net.minecraft.class_2561;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdaptiveOptionsPanel
extends AbstractOptionsPanel {
    private static final class_7919 ADAPTIVE_INFO = class_7919.method_47407((class_2561)class_2561.method_43471((String)"cursors_extended.options.adapt.tooltip"));
    private static final class_2561 HOLD_CURSORS = class_2561.method_43471((String)"cursors_extended.options.adapt.hold");
    private static final class_7919 HOLD_CURSORS_INFO = class_7919.method_47407((class_2561)class_2561.method_43471((String)"cursors_extended.options.adapt.hold.tooltip"));
    private static final class_2561 ITEM_SLOT = class_2561.method_43471((String)"cursors_extended.options.adapt.item_slot");
    private static final class_2561 ITEM_GRAB = class_2561.method_43471((String)"cursors_extended.options.adapt.item_grab");
    private static final class_2561 SCROLLBAR_POINTER = AdaptiveOptionsPanel.scrollbarText(class_11876.field_62455);
    private static final class_2561 SCROLLBAR_RESIZE = AdaptiveOptionsPanel.scrollbarText(class_11876.field_62456);
    private static final class_2561 CREATIVE_TABS = class_2561.method_43471((String)"cursors_extended.options.adapt.creative_tabs");
    private static final class_2561 ENCHANTMENTS = class_2561.method_43471((String)"cursors_extended.options.adapt.enchantments");
    private static final class_2561 STONECUTTER = class_2561.method_43471((String)"cursors_extended.options.adapt.stonecutter");
    private static final class_2561 LOOM = class_2561.method_43471((String)"cursors_extended.options.adapt.loom");
    private static final class_2561 ADVANCEMENTS = class_2561.method_43471((String)"cursors_extended.options.adapt.advancements");
    private static final class_2561 WORLD = class_2561.method_43471((String)"cursors_extended.options.adapt.world");
    private static final class_2561 SERVER = class_2561.method_43471((String)"cursors_extended.options.adapt.server");
    private static final int CURSOR_SIZE_STEP = 8;
    private final Runnable refreshCursors;
    private OptionsListWidget optionsList;

    public AdaptiveOptionsPanel(class_2561 title, Runnable refreshCursors) {
        super(title);
        this.refreshCursors = refreshCursors;
    }

    @Override
    protected void initContents() {
        this.optionsList = new OptionsListWidget(this.getMinecraft(), this.getFont(), 20, this.getSpacing());
        boolean adaptive = this.isAdaptive();
        this.optionsList.addToggle(adaptive, this::toggleAdaptive, ENABLE_TEXT, ADAPTIVE_INFO, true);
        this.addOption(CursorsExtended.CONFIG.isHeldCursorsEnabled(), CursorsExtended.CONFIG::setHeldCursorsEnabled, HOLD_CURSORS, HOLD_CURSORS_INFO, null, adaptive);
        this.addOption(CursorsExtended.CONFIG.isItemSlotEnabled(), CursorsExtended.CONFIG::setItemSlotEnabled, ITEM_SLOT, class_11876.field_62455, adaptive);
        this.addOption(CursorsExtended.CONFIG.isItemGrabbingEnabled(), CursorsExtended.CONFIG::setItemGrabbingEnabled, ITEM_GRAB, CursorTypesExt.GRABBING, adaptive);
        this.addOption(CursorsExtended.CONFIG.isPointerScrollbarEnabled(), CursorsExtended.CONFIG::setPointerScrollbarEnabled, SCROLLBAR_POINTER, class_11876.field_62455, adaptive);
        this.addOption(CursorsExtended.CONFIG.isResizeScrollbarEnabled(), CursorsExtended.CONFIG::setResizeScrollbarEnabled, SCROLLBAR_RESIZE, class_11876.field_62456, adaptive);
        this.addOption(CursorsExtended.CONFIG.isCreativeTabsEnabled(), CursorsExtended.CONFIG::setCreativeTabsEnabled, CREATIVE_TABS, class_11876.field_62455, adaptive);
        this.addOption(CursorsExtended.CONFIG.isEnchantmentsEnabled(), CursorsExtended.CONFIG::setEnchantmentsEnabled, ENCHANTMENTS, class_11876.field_62455, adaptive);
        this.addOption(CursorsExtended.CONFIG.isStonecutterRecipesEnabled(), CursorsExtended.CONFIG::setStonecutterRecipesEnabled, STONECUTTER, class_11876.field_62455, adaptive);
        this.addOption(CursorsExtended.CONFIG.isLoomPatternsEnabled(), CursorsExtended.CONFIG::setLoomPatternsEnabled, LOOM, class_11876.field_62455, adaptive);
        this.addOption(CursorsExtended.CONFIG.isAdvancementTabsEnabled(), CursorsExtended.CONFIG::setAdvancementTabsEnabled, ADVANCEMENTS, class_11876.field_62455, adaptive);
        this.addOption(CursorsExtended.CONFIG.isWorldIconEnabled(), CursorsExtended.CONFIG::setWorldIconEnabled, WORLD, class_11876.field_62455, adaptive);
        this.addOption(CursorsExtended.CONFIG.isServerIconEnabled(), CursorsExtended.CONFIG::setServerIconEnabled, SERVER, class_11876.field_62455, adaptive);
        this.optionsList.search(this.getSearch());
        this.addRenderableWidget(this.optionsList);
    }

    private void addOption(boolean value, Consumer<Boolean> consumer, class_2561 label, class_11875 cursorType, boolean active) {
        this.addOption(value, consumer, label, null, cursorType, active);
    }

    private void addOption(boolean value, Consumer<Boolean> consumer, class_2561 label, class_7919 tooltip, class_11875 cursorType, boolean active) {
        this.optionsList.addToggle(value && active, consumer, this.index(label), this.prefixCursor(cursorType), tooltip, active);
    }

    private OptionsListWidget.Prefix prefixCursor(class_11875 cursorType) {
        if (cursorType == null) {
            return null;
        }
        Cursor cursor = CursorsExtended.getInstance().getRegistry().get(cursorType);
        return (guiGraphics, font, x, y, height) -> {
            int adjustedHeight = height - height % 8;
            int offsetY = y + (height - adjustedHeight) / 2;
            DrawUtil.drawCursor(guiGraphics, cursor, x, offsetY, adjustedHeight);
            return adjustedHeight;
        };
    }

    @Override
    protected void repositionContents(int x, int y) {
        if (this.optionsList != null) {
            this.optionsList.method_55445(this.method_25368(), this.computeMaxHeight(y));
            this.optionsList.method_48229(x, y);
        }
    }

    @Override
    protected void searched(@NotNull String search, @Nullable class_2561 matched) {
        if (this.optionsList != null) {
            this.optionsList.search(search);
        }
    }

    private void toggleAdaptive(boolean adaptive) {
        for (Cursor cursor : CursorsExtended.getInstance().getRegistry().getInternalCursors()) {
            if (cursor.cursorType() == class_11875.field_62449) continue;
            if (adaptive && cursor.getTexture() == null) {
                AdaptiveOptionsPanel.loadCursor(cursor);
            }
            cursor.setEnabled(adaptive);
            CursorsExtended.CONFIG.getOrCreateSettings(cursor).setEnabled(adaptive);
        }
        this.refreshCursors.run();
        this.refreshWidgets();
        this.repositionElements();
    }

    private boolean isAdaptive() {
        for (Cursor cursor : CursorsExtended.getInstance().getRegistry().getInternalCursors()) {
            if (!CursorTypeUtil.nonDefault(cursor.cursorType()) || !cursor.isTextureEnabled()) continue;
            return true;
        }
        return false;
    }

    private static class_2561 scrollbarText(class_11875 cursorType) {
        return class_2561.method_43469((String)"cursors_extended.options.adapt.scrollbar", (Object[])new Object[]{class_2561.method_43471((String)("cursors_extended.options.cursor-type." + cursorType.toString()))});
    }
}

