/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.screen.panel;

import com.mojang.datafixers.util.Pair;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.config.Config;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorRegistry;
import io.github.fishstiz.cursors_extended.gui.MouseEvent;
import io.github.fishstiz.cursors_extended.gui.screen.panel.AbstractOptionsPanel;
import io.github.fishstiz.cursors_extended.gui.widget.ButtonWidget;
import io.github.fishstiz.cursors_extended.gui.widget.CursorPreviewWidget;
import io.github.fishstiz.cursors_extended.gui.widget.OptionsListWidget;
import io.github.fishstiz.cursors_extended.gui.widget.SliderWidget;
import io.github.fishstiz.cursors_extended.resource.texture.AnimatedCursorTexture;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import java.util.Iterator;
import java.util.function.Consumer;
import net.minecraft.class_11875;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalOptionsPanel
extends AbstractOptionsPanel {
    private static final class_2561 TITLE = class_2561.method_43471((String)"cursors_extended.options.global.title");
    private static final class_7919 SCALE_TOOLTIP = GlobalOptionsPanel.createGlobalTooltip(SCALE_TEXT);
    private static final class_7919 XHOT_TOOLTIP = GlobalOptionsPanel.createGlobalTooltip(XHOT_TEXT);
    private static final class_7919 YHOT_TOOLTIP = GlobalOptionsPanel.createGlobalTooltip(YHOT_TEXT);
    private static final class_2561 ANIMATIONS_TEXT = class_2561.method_43471((String)"cursors_extended.options.global.animation");
    private static final class_7919 ANIMATIONS_INFO = class_7919.method_47407((class_2561)class_2561.method_43471((String)"cursors_extended.options.global.animation.tooltip"));
    private static final class_2561 RESET_TEXT = class_2561.method_43471((String)"cursors_extended.options.resource_pack.reset");
    private static final class_7919 RESET_INFO = class_7919.method_47407((class_2561)class_2561.method_43471((String)"cursors_extended.options.resource_pack.reset.tooltip"));
    private static final int PREVIEW_BUTTON_SIZE = 20;
    private final Runnable refreshCursors;
    @NotNull
    private Iterator<Cursor> cursors = GlobalOptionsPanel.cursorIterator();
    @NotNull
    private Cursor currentCursor = GlobalOptionsPanel.getDefaultCursor();
    private OptionsListWidget optionList;
    private GlobalPreviewWidget previewWidget;
    private boolean scaling = false;

    public GlobalOptionsPanel(Runnable refreshCursors) {
        super(TITLE);
        this.refreshCursors = refreshCursors;
    }

    @Override
    protected void initContents() {
        this.recycleCursors();
        Pair<Integer, Integer> maxHotspot = GlobalOptionsPanel.getMaxHotspots();
        this.previewWidget = new GlobalPreviewWidget(this.currentCursor, this.getFont(), new ButtonWidget(class_5244.field_39003, this::cycleOnPreviewPress).withSize(20));
        this.optionList = new OptionsListWidget(this.getMinecraft(), this.getFont(), 20, this.getSpacing());
        this.optionList.addToggleableSlider(new SliderWidget(CursorsExtended.CONFIG.getGlobal().scale(), 0.0, 8.0, 0.05f, this::onChangeScale, this.index(SCALE_TEXT), class_5244.field_39003, SettingsUtil::getAutoText, this::onSliderMouseEvent), CursorsExtended.CONFIG.getGlobal().isScaleActive(), GlobalOptionsPanel.applyGlobalOnToggle(CursorsExtended.CONFIG.getGlobal()::setScaleActive), SCALE_TOOLTIP);
        this.optionList.addToggleableSlider(new SliderWidget(CursorsExtended.CONFIG.getGlobal().xhot(), 0.0, ((Integer)maxHotspot.getFirst()).intValue(), 1.0, this::onChangeXHot, this.index(XHOT_TEXT), HOTSPOT_SUFFIX, null, this::onSliderMouseEvent), CursorsExtended.CONFIG.getGlobal().isXHotActive(), GlobalOptionsPanel.applyGlobalOnToggle(CursorsExtended.CONFIG.getGlobal()::setXHotActive), XHOT_TOOLTIP);
        this.optionList.addToggleableSlider(new SliderWidget(CursorsExtended.CONFIG.getGlobal().yhot(), 0.0, ((Integer)maxHotspot.getSecond()).intValue(), 1.0, this::onChangeYHot, this.index(YHOT_TEXT), HOTSPOT_SUFFIX, null, this::onSliderMouseEvent), CursorsExtended.CONFIG.getGlobal().isYHotActive(), GlobalOptionsPanel.applyGlobalOnToggle(CursorsExtended.CONFIG.getGlobal()::setYHotActive), YHOT_TOOLTIP);
        this.optionList.addToggle(this.isAnimatedAny(), this::toggleCursorAnimations, this.index(ANIMATIONS_TEXT), ANIMATIONS_INFO, this.hasAnimationAny());
        this.optionList.addWidget((class_339)new ButtonWidget(this.index(RESET_TEXT), this::resetCursorSettings).withTooltip(RESET_INFO));
        this.optionList.search(this.getSearch());
        this.addRenderableWidget(this.previewWidget);
        this.addRenderableWidget(this.optionList);
    }

    @Override
    protected void repositionContents(int x, int y) {
        if (this.previewWidget != null && this.optionList != null) {
            this.previewWidget.method_25358(this.method_25368());
            this.previewWidget.method_48229(x, y);
            this.optionList.method_55445(this.method_25368(), this.computeMaxHeight(y) - this.previewWidget.method_25364() - this.getSpacing());
            this.optionList.method_48229(x, this.previewWidget.method_55443() + this.getSpacing());
        }
    }

    private void onChangeScale(double scale) {
        CursorsExtended.CONFIG.getGlobal().setScale((float)scale);
        if (CursorsExtended.CONFIG.getGlobal().isScaleActive()) {
            GlobalOptionsPanel.setScale(this.currentCursor, (float)scale);
        }
    }

    private void onChangeXHot(double xhot) {
        CursorsExtended.CONFIG.getGlobal().setXHot(xhot);
        if (CursorsExtended.CONFIG.getGlobal().isXHotActive()) {
            GlobalOptionsPanel.setXHot(this.currentCursor, (int)xhot);
        }
    }

    private void onChangeYHot(double yhot) {
        CursorsExtended.CONFIG.getGlobal().setYHot(yhot);
        if (CursorsExtended.CONFIG.getGlobal().isYHotActive()) {
            GlobalOptionsPanel.setYHot(this.currentCursor, (int)yhot);
        }
    }

    private void onSliderMouseEvent(SliderWidget target, MouseEvent mouseEvent, double scale) {
        if (target.getPrefix().equals((Object)SCALE_TEXT)) {
            boolean bl = this.scaling = (mouseEvent.clicked() || mouseEvent.dragged()) && this.currentCursor.isTextureEnabled();
        }
        if (mouseEvent.released()) {
            CursorRegistry registry = CursorsExtended.getInstance().getRegistry();
            if (target.getPrefix().equals((Object)SCALE_TEXT) && CursorsExtended.CONFIG.getGlobal().isScaleActive()) {
                registry.getInternalCursors().forEach(cursor -> GlobalOptionsPanel.setScale(cursor, CursorsExtended.CONFIG.getGlobal().scale()));
            } else if (target.getPrefix().equals((Object)XHOT_TEXT) && CursorsExtended.CONFIG.getGlobal().isXHotActive()) {
                registry.getInternalCursors().forEach(cursor -> GlobalOptionsPanel.setXHot(cursor, CursorsExtended.CONFIG.getGlobal().xhot()));
            } else if (target.getPrefix().equals((Object)YHOT_TEXT) && CursorsExtended.CONFIG.getGlobal().isYHotActive()) {
                registry.getInternalCursors().forEach(cursor -> GlobalOptionsPanel.setYHot(cursor, CursorsExtended.CONFIG.getGlobal().yhot()));
            }
        }
    }

    private void cycleOnPreviewPress(class_4185 target) {
        target.method_25365(false);
        this.cycleCurrentCursor();
    }

    private void cycleCurrentCursor() {
        if (!this.cursors.hasNext()) {
            this.cursors = GlobalOptionsPanel.cursorIterator();
        }
        Cursor cursor = this.currentCursor = this.cursors.hasNext() ? this.cursors.next() : GlobalOptionsPanel.getDefaultCursor();
        if (this.previewWidget != null) {
            this.previewWidget.setCursor(this.currentCursor);
        }
    }

    private void recycleCursors() {
        this.cursors = GlobalOptionsPanel.cursorIterator();
        this.cycleCurrentCursor();
    }

    private void toggleCursorAnimations(boolean animated) {
        for (Cursor cursor : CursorsExtended.getInstance().getRegistry().getInternalCursors()) {
            CursorTexture cursorTexture = cursor.getTexture();
            if (!(cursorTexture instanceof AnimatedCursorTexture)) continue;
            AnimatedCursorTexture animatedCursor = (AnimatedCursorTexture)cursorTexture;
            animatedCursor.setAnimated(animated);
            CursorsExtended.CONFIG.getOrCreateSettings(cursor).setAnimated(animated);
        }
    }

    private void resetCursorSettings() {
        for (Cursor cursor : CursorsExtended.getInstance().getRegistry().getCursors()) {
            CursorTexture texture = cursor.getTexture();
            if (texture == null) continue;
            Config.CursorSettings settings = CursorsExtended.CONFIG.getOrCreateSettings(cursor);
            settings.mergeAll(texture.metadata().cursor());
            cursor.setEnabled(settings.enabled());
            CursorsExtended.CONFIG.putCursorSettings(cursor, settings);
            CursorsExtended.getInstance().getLoader().updateTexture(cursor, CursorsExtended.CONFIG.getGlobal().apply(settings));
        }
        this.refreshCursors.run();
        this.refreshWidgets();
        this.repositionElements();
    }

    @Override
    protected void searched(@NotNull String search, @Nullable class_2561 matched) {
        if (this.optionList != null) {
            this.optionList.search(search);
        }
    }

    public boolean hasAnimationAny() {
        for (Cursor cursor : CursorsExtended.getInstance().getRegistry().getInternalCursors()) {
            if (!(cursor.getTexture() instanceof AnimatedCursorTexture)) continue;
            return true;
        }
        return false;
    }

    public boolean isAnimatedAny() {
        for (Cursor cursor : CursorsExtended.getInstance().getRegistry().getInternalCursors()) {
            AnimatedCursorTexture animatedCursor;
            CursorTexture cursorTexture = cursor.getTexture();
            if (!(cursorTexture instanceof AnimatedCursorTexture) || !(animatedCursor = (AnimatedCursorTexture)cursorTexture).animated().booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static Consumer<Boolean> applyGlobalOnToggle(Consumer<Boolean> onToggle) {
        return value -> {
            onToggle.accept((Boolean)value);
            CursorsExtended.getInstance().getRegistry().getInternalCursors().forEach(cursor -> CursorsExtended.getInstance().getLoader().updateTexture((Cursor)cursor, CursorsExtended.CONFIG.getGlobal().apply(CursorsExtended.CONFIG.getOrCreateSettings((Cursor)cursor))));
        };
    }

    private static class_7919 createGlobalTooltip(class_2561 message) {
        return class_7919.method_47407((class_2561)class_2561.method_43469((String)"cursors_extended.options.global.tooltip", (Object[])new Object[]{message}));
    }

    private static Iterator<Cursor> cursorIterator() {
        return CursorsExtended.getInstance().getRegistry().getInternalCursors().stream().filter(Cursor::isTextureEnabled).iterator();
    }

    @NotNull
    private static Cursor getDefaultCursor() {
        return CursorsExtended.getInstance().getRegistry().get(class_11875.field_62449);
    }

    private static Pair<Integer, Integer> getMaxHotspots() {
        int currentMaxX = -1;
        int currentMaxY = -1;
        for (Cursor cursor : CursorsExtended.getInstance().getRegistry().getInternalCursors()) {
            int maxYHot;
            if (!cursor.hasTexture()) continue;
            int maxXHot = SettingsUtil.getMaxXHot(cursor);
            if (maxXHot > currentMaxX) {
                currentMaxX = maxXHot;
            }
            if ((maxYHot = SettingsUtil.getMaxYHot(cursor)) <= currentMaxY) continue;
            currentMaxY = maxYHot;
        }
        return new Pair((Object)(currentMaxX != -1 ? currentMaxX : 0), (Object)(currentMaxY != -1 ? currentMaxY : 0));
    }

    @Override
    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.scaling) {
            guiGraphics.method_74037(CursorTypeUtil.arrowIfDefault(this.currentCursor.cursorType()));
        }
    }

    private static class GlobalPreviewWidget
    extends CursorPreviewWidget {
        private static final float CELL_DIVISOR = 32.0f;
        @NotNull
        private Cursor cursor;

        public GlobalPreviewWidget(@NotNull Cursor cursor, @NotNull class_327 font, @Nullable class_4185 button) {
            super(cursor, font, button);
            this.cursor = cursor;
        }

        @Override
        protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.renderBackground(guiGraphics);
            this.renderPreviewText(guiGraphics);
            this.renderTestButton(guiGraphics, mouseX, mouseY, partialTick);
            this.renderRuler(guiGraphics, mouseX, mouseY);
            this.renderBorder(guiGraphics);
            if (this.method_49606()) {
                guiGraphics.method_74037(this.cursors_extended$cursorType(mouseX, mouseY));
            }
        }

        @Override
        protected float getCellWidth() {
            return (float)this.method_25368() / 32.0f;
        }

        @Override
        protected float getCellHeight() {
            return this.getCellWidth();
        }

        @Override
        protected boolean isOverflowing() {
            return false;
        }

        public void setCursor(@NotNull Cursor cursor) {
            this.cursor = cursor;
        }

        @Override
        @NotNull
        public Cursor getCursor() {
            return this.cursor;
        }
    }
}

