/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.resource.texture;

import io.github.fishstiz.cursors_extended.config.CursorMetadata;
import io.github.fishstiz.cursors_extended.config.CursorProperties;
import io.github.fishstiz.cursors_extended.resource.texture.AbstractCursorTexture;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import io.github.fishstiz.cursors_extended.util.NativeImageUtil;
import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import java.io.IOException;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public final class BasicCursorTexture
extends AbstractCursorTexture
implements CursorTexture.Stateful {
    private final float scale;
    private final int xhot;
    private final int yhot;
    private final int textureWidth;
    private final int textureHeight;
    private final byte[] pixels;
    private final class_2960 texturePath;
    private final CursorMetadata metadata;
    private boolean enabled;

    public BasicCursorTexture(class_1011 image, class_2960 texturePath, CursorMetadata metadata, CursorProperties settings) throws IOException {
        super(image, settings);
        this.enabled = settings.enabled();
        this.scale = SettingsUtil.sanitizeScale(settings.scale());
        this.xhot = SettingsUtil.sanitizeHotspot(settings.xhot(), image.method_4307());
        this.yhot = SettingsUtil.sanitizeHotspot(settings.yhot(), image.method_4323());
        this.textureWidth = image.method_4307();
        this.textureHeight = image.method_4323();
        this.pixels = NativeImageUtil.getBytes(image);
        this.texturePath = texturePath;
        this.metadata = metadata;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void toggle() {
        this.enabled = !this.enabled;
    }

    @Override
    public long handle() {
        return this.enabled ? super.handle() : 0L;
    }

    @Override
    public float scale() {
        return this.scale;
    }

    @Override
    public int xhot() {
        return this.xhot;
    }

    @Override
    public int yhot() {
        return this.yhot;
    }

    @Override
    public Boolean animated() {
        return false;
    }

    @Override
    public int textureWidth() {
        return this.textureWidth;
    }

    @Override
    public int textureHeight() {
        return this.textureHeight;
    }

    @Override
    public CursorMetadata metadata() {
        return this.metadata;
    }

    @NotNull
    public class_2960 comp_3627() {
        return this.texturePath;
    }

    @Override
    public CursorTexture recreate(CursorProperties properties) throws IOException {
        try (class_1011 image = class_1011.method_49277((byte[])this.pixels);){
            BasicCursorTexture basicCursorTexture = new BasicCursorTexture(image, this.texturePath, this.metadata, properties);
            return basicCursorTexture;
        }
    }
}

