/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.mixin.cursorhandler;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursor.handler.InternalCursorProvider;
import io.github.fishstiz.minecraftcursor.mixin.cursorhandler.access.OnlineServerEntryAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.multiplayer.ServerSelectionList;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ServerSelectionList.class})
public abstract class ServerSelectionListMixin
extends ObjectSelectionList<ServerSelectionList.Entry>
implements InternalCursorProvider {
    @Unique
    private static final int minecraft_cursor$ICON_WIDTH = 32;
    @Unique
    private static final int minecraft_cursor$MOVE_ICON_SIZE = 16;

    protected ServerSelectionListMixin(Minecraft minecraft, int width, int height, int y, int itemHeight) {
        super(minecraft, width, height, y, itemHeight);
    }

    @Override
    @NotNull
    public CursorType minecraft_cursor$getCursorType(double mouseX, double mouseY) {
        AbstractSelectionList.Entry entry;
        if (MinecraftCursor.CONFIG.isServerIconEnabled() && mouseX < (double)(this.getRowLeft() + 32) && (entry = this.getEntryAtPosition(mouseX, mouseY)) instanceof ServerSelectionList.OnlineServerEntry) {
            ServerSelectionList.OnlineServerEntry serverEntry = (ServerSelectionList.OnlineServerEntry)entry;
            OnlineServerEntryAccessor accessor = (OnlineServerEntryAccessor)serverEntry;
            int i = this.children().indexOf(serverEntry);
            double relativeX = mouseX - (double)this.getRowLeft();
            double relativeY = mouseY - (double)this.getRowTop(i);
            if (relativeX < 32.0 && relativeX > 16.0 && accessor.invokeCanJoin()) {
                return CursorType.POINTER;
            }
            if (relativeX < 16.0 && relativeY < 16.0 && i > 0) {
                return CursorType.POINTER;
            }
            if (relativeX < 16.0 && relativeY > 16.0 && i < accessor.getScreen().getServers().size() - 1) {
                return CursorType.POINTER;
            }
        }
        return CursorType.DEFAULT;
    }
}

