/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.cursor;

import io.github.fishstiz.cursors_extended.CursorsExtended;

public enum AnimationMode {
    LOOP,
    LOOP_REVERSE,
    FORWARDS,
    REVERSE,
    OSCILLATE,
    RANDOM,
    RANDOM_CYCLE;


    public boolean isReversed() {
        return this == LOOP_REVERSE || this == REVERSE;
    }

    public String toString() {
        return this.name().toLowerCase();
    }

    public static AnimationMode getOrDefault(String name) {
        try {
            return AnimationMode.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            CursorsExtended.LOGGER.warn("[cursors-extended] Animation mode: '{}' does not exist. Using default 'loop'.", (Object)name);
            return LOOP;
        }
    }
}

