/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.screen.panel;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.gui.screen.CatalogBrowserScreen;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractOptionsPanel
extends CatalogBrowserScreen.ContentPanel {
    protected static final Component ENABLE_TEXT = Component.translatable((String)"cursors_extended.options.enabled");
    protected static final Component SCALE_TEXT = Component.translatable((String)"cursors_extended.options.scale");
    protected static final Component GUI_SCALE_TEXT = Component.translatable((String)"cursors_extended.options.scale.gui");
    protected static final Component XHOT_TEXT = Component.translatable((String)"cursors_extended.options.xhot");
    protected static final Component YHOT_TEXT = Component.translatable((String)"cursors_extended.options.yhot");
    protected static final Component HOTSPOT_SUFFIX = Component.translatable((String)"cursors_extended.options.hotspot-suffix");
    private final Component title;
    private StringWidget titleWidget;

    protected AbstractOptionsPanel(Component title) {
        this.title = title.copy().withStyle(ChatFormatting.BOLD);
    }

    protected abstract void initContents();

    protected abstract void repositionContents(int var1, int var2);

    @Override
    protected final void init() {
        this.titleWidget = new StringWidget(this.title, this.getFont());
        this.addRenderableIndexedWidget((AbstractWidget)this.titleWidget);
        this.initContents();
    }

    @Override
    protected final void repositionElements() {
        this.titleWidget.setSize(this.getHeaderWidth(), this.getHeaderHeight());
        this.titleWidget.setMaxWidth(this.getHeaderWidth(), StringWidget.TextOverflow.CLAMPED);
        this.titleWidget.setPosition(this.getX(), this.getY());
        this.repositionContents(this.getX(), this.getY() + this.titleWidget.getHeight() + this.getSpacing());
    }

    protected int computeMaxHeight(int top) {
        return Math.max(0, this.getHeight() - (top - this.getY()));
    }

    static boolean loadCursor(@NotNull Cursor deferredCursor) {
        CursorTexture texture = deferredCursor.getTexture();
        if (texture != null) {
            throw new IllegalStateException("Cursor is already loaded");
        }
        if (CursorsExtended.getInstance().getLoader().loadTexture(deferredCursor)) {
            return true;
        }
        Minecraft.getInstance().getToastManager().addToast((Toast)SystemToast.multiline((Minecraft)Minecraft.getInstance(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PACK_LOAD_FAILURE, (Component)Component.translatable((String)"resourcePack.load_fail"), (Component)Component.translatable((String)"cursors_extended.options.global.deferred_loading.fail", (Object[])new Object[]{deferredCursor.text()})));
        return false;
    }

    static void setScale(Cursor cursor, float scale) {
        CursorTexture cursorTexture = cursor.getTexture();
        if (cursorTexture instanceof CursorTexture.Stateful) {
            CursorTexture.Stateful texture = (CursorTexture.Stateful)cursorTexture;
            CursorsExtended.getInstance().getLoader().updateTexture(cursor, scale, texture.xhot(), texture.yhot());
        }
    }

    static void setXHot(Cursor cursor, int xhot) {
        CursorTexture cursorTexture = cursor.getTexture();
        if (cursorTexture instanceof CursorTexture.Stateful) {
            CursorTexture.Stateful texture = (CursorTexture.Stateful)cursorTexture;
            CursorsExtended.getInstance().getLoader().updateTexture(cursor, texture.scale(), xhot, texture.yhot());
        }
    }

    static void setYHot(Cursor cursor, int yhot) {
        CursorTexture cursorTexture = cursor.getTexture();
        if (cursorTexture instanceof CursorTexture.Stateful) {
            CursorTexture.Stateful texture = (CursorTexture.Stateful)cursorTexture;
            CursorsExtended.getInstance().getLoader().updateTexture(cursor, texture.scale(), texture.xhot(), yhot);
        }
    }

    protected void refreshWidgets() {
        this.clearWidgets();
        this.init();
    }

    @Override
    protected void added() {
        this.refreshWidgets();
    }
}

