/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.cursor.CursorType;
import com.mojang.blaze3d.platform.cursor.CursorTypes;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.CursorDisplay;
import io.github.fishstiz.cursors_extended.cursor.CursorRegistry;
import io.github.fishstiz.cursors_extended.cursor.CursorTypesExt;
import io.github.fishstiz.cursors_extended.cursor.TexturedCursorType;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CursorType.class})
public abstract class CursorTypeMixin
implements TexturedCursorType {
    @Unique
    private CursorTexture cursors_extended$texture;

    @Shadow
    public abstract void select(Window var1);

    @Override
    @Nullable
    public CursorTexture cursors_extended$getTexture() {
        return this.cursors_extended$texture;
    }

    @Override
    public void cursors_extended$setTexture(CursorTexture texture) {
        CursorTexture previousTexture = this.cursors_extended$texture;
        this.cursors_extended$texture = texture;
        CursorDisplay cursorDisplay = CursorsExtended.getInstance().getDisplay();
        CursorRegistry cursorRegistry = CursorsExtended.getInstance().getRegistry();
        if (cursorDisplay.getDisplayedCursor() == cursorRegistry.get((CursorType)this)) {
            this.select(cursorDisplay.getWindow());
        }
        if (previousTexture != null && previousTexture != texture) {
            previousTexture.close();
        }
    }

    @WrapOperation(method={"select"}, at={@At(value="FIELD", target="Lcom/mojang/blaze3d/platform/cursor/CursorType;handle:J")})
    private long onSetCursor(CursorType instance, Operation<Long> original) {
        if (this.cursors_extended$texture != null && this.cursors_extended$texture.handle() != 0L) {
            return this.cursors_extended$texture.handle();
        }
        return (Long)original.call(new Object[]{instance});
    }

    @Inject(method={"createStandardCursor"}, at={@At(value="RETURN")})
    private static void registerStandardCursors(int shape, String name, CursorType fallback, CallbackInfoReturnable<CursorType> cir) {
        CursorType standardCursorType;
        if (cir.getReturnValue() != null && (standardCursorType = CursorTypeMixin.cursors_extended$mapStandardCursor(shape)) != null) {
            CursorsExtended.LOGGER.info("[cursors_extended] Registering an alias for {}: {}", (Object)standardCursorType, (Object)name);
            CursorsExtended.getInstance().getRegistry().registerAlias(standardCursorType, (CursorType)cir.getReturnValue());
        }
    }

    @Unique
    @Nullable
    private static CursorType cursors_extended$mapStandardCursor(int shape) {
        return switch (shape) {
            case 221185 -> CursorType.DEFAULT;
            case 221188 -> CursorTypes.POINTING_HAND;
            case 221186 -> CursorTypes.IBEAM;
            case 221187 -> CursorTypes.CROSSHAIR;
            case 221189 -> CursorTypes.RESIZE_EW;
            case 221190 -> CursorTypes.RESIZE_NS;
            case 221191 -> CursorTypesExt.RESIZE_NWSE;
            case 221192 -> CursorTypesExt.RESIZE_NESW;
            case 221193 -> CursorTypes.RESIZE_ALL;
            case 221194 -> CursorTypes.NOT_ALLOWED;
            default -> null;
        };
    }

    static {
        CursorsExtended.LOGGER.debug("[cursors_extended] Initializing CursorTypes: {}", CursorTypes.class);
    }
}

