package io.github.fishstiz.minecraftcursor.cursorhandler.ingame;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.mixin.access.LoomScreenAccessor;
import java.util.List;
import net.minecraft.class_1726;
import net.minecraft.class_2582;
import net.minecraft.class_494;
import net.minecraft.class_6880;

public class LoomScreenCursorHandler extends HandledScreenCursorHandler<class_1726, class_494> {
    // Derived from LoomScreen#drawBackground
    public static final int PATTERNS_OFFSET_X = 60;
    public static final int PATTERNS_OFFSET_Y = 13;
    public static final int GRID_SIZE = 4;
    public static final int PATTERN_SIZE = 14;

    @Override
    public CursorType getCursorType(class_494 loomScreen, double mouseX, double mouseY) {
        CursorType cursorType = super.getCursorType(loomScreen, mouseX, mouseY);
        if (cursorType != CursorType.DEFAULT) return cursorType;

        if (!MinecraftCursor.CONFIG.isLoomPatternsEnabled()) return CursorType.DEFAULT;

        LoomScreenAccessor loomScreenAccessor = (LoomScreenAccessor) loomScreen;

        if (!loomScreenAccessor.getCanApplyDyePattern()) return CursorType.DEFAULT;

        class_1726 handler = loomScreenAccessor.getHandler();
        List<class_6880<class_2582>> patterns = handler.method_43706();
        int patternsX = loomScreenAccessor.getX() + PATTERNS_OFFSET_X;
        int patternsY = loomScreenAccessor.getY() + PATTERNS_OFFSET_Y;

        grid:
        for (int row = 0; row < GRID_SIZE; row++) {
            for (int col = 0; col < GRID_SIZE; col++) {
                int patternIndex = row + loomScreenAccessor.getVisibleTopRow();
                int patternSlot = patternIndex * GRID_SIZE + col;
                if (patternSlot >= patterns.size()) {
                    break grid;
                }
                int patternX = patternsX + col * PATTERN_SIZE;
                int patternY = patternsY + row * PATTERN_SIZE;
                if (mouseX >= patternX
                        && mouseY >= patternY
                        && mouseX < patternX + PATTERN_SIZE
                        && mouseY < patternY + PATTERN_SIZE) {
                    return CursorType.POINTER;
                }
            }
        }
        return CursorType.DEFAULT;
    }
}
