/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.compat;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.cursor.CursorType;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.compat.CursorStateTrackerImpl;
import io.github.fishstiz.cursors_extended.compat.ModCursor;
import org.jetbrains.annotations.Nullable;

public sealed interface CursorStateTracker
permits CursorStateTrackerImpl, CursorStateTrackerImpl.DefaultTracker {
    public void trackCursor(ModCursor var1);

    public void resetCursor(long var1, String var3);

    public void setCursor(long var1, ModCursor var3);

    default public void untrackCursor(ModCursor cursor) {
    }

    default public boolean isTracking() {
        return false;
    }

    @Nullable
    default public ModCursor getCursor(long handle) {
        return null;
    }

    default public CursorType getCurrentCursor(long window) {
        return CursorType.DEFAULT;
    }

    public static CursorStateTracker get() {
        return CursorStateTrackerImpl.getOrDefault();
    }

    public static StackWalker getStackWalker() {
        return CursorStateTrackerImpl.getStackWalker();
    }

    public static void syncWithMinecraft(long window, CursorType cursorType) {
        Window minecraftWindow = CursorsExtended.getInstance().getDisplay().getWindow();
        if (window == minecraftWindow.handle()) {
            minecraftWindow.currentCursor = cursorType;
        }
    }
}

