/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.config;

import io.github.fishstiz.cursors_extended.compat.ModCursor;
import io.github.fishstiz.cursors_extended.config.CursorProperties;
import io.github.fishstiz.cursors_extended.config.JsonLoader;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.platform.Services;
import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.Serializable;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Config
implements Serializable {
    private String _hash;
    private boolean itemSlotEnabled = true;
    private boolean itemGrabbingEnabled = true;
    private boolean creativeTabsEnabled = true;
    private boolean enchantmentsEnabled = true;
    private boolean stonecutterRecipesEnabled = true;
    private boolean loomPatternsEnabled = true;
    private boolean advancementTabsEnabled = true;
    private boolean worldIconEnabled = true;
    private boolean serverIconEnabled = true;
    private boolean pointerScrollbarEnabled = true;
    private boolean resizeScrollbarEnabled = true;
    private boolean heldCursorsEnabled = true;
    private boolean aggressiveCursor = false;
    private boolean virtualMode = false;
    private boolean legacyMode = true;
    private boolean showHotspotGuide = true;
    private boolean remapStandardCursors = true;
    private boolean workarounds = true;
    private final GlobalSettings global = new GlobalSettings();
    private final Object2ObjectOpenHashMap<String, CursorSettings> cursors = new Object2ObjectOpenHashMap();
    private transient Map<String, CursorSettings> unknownCursors;
    private transient boolean stale = false;

    Config() {
    }

    public static Config defaults() {
        return new Config();
    }

    public CursorSettings getOrCreateSettings(Cursor cursor) {
        String name = cursor.name();
        CursorSettings settings = (CursorSettings)this.cursors.get((Object)name);
        if (settings != null) {
            return settings;
        }
        if (this.unknownCursors != null && (settings = this.unknownCursors.get(name)) != null) {
            return settings;
        }
        settings = new CursorSettings();
        if (ModCursor.isUnknown(cursor.cursorType())) {
            if (this.unknownCursors == null) {
                this.unknownCursors = new Object2ObjectOpenHashMap();
            }
            this.unknownCursors.put(name, settings);
        } else {
            this.cursors.put((Object)name, (Object)settings);
        }
        return settings;
    }

    public boolean isStale(Cursor cursor) {
        return this.stale || !this.cursors.containsKey((Object)cursor.name());
    }

    public void markSettingsStale() {
        this.stale = true;
    }

    @Nullable
    public String getHash() {
        return this._hash;
    }

    public void setHash(String hash) {
        this._hash = hash;
    }

    public static Config load() {
        return JsonLoader.loadOrDefault(Config.class, Services.PLATFORM.getConfigDir().resolve("cursors_extended"), Config::new);
    }

    public void save() {
        JsonLoader.save(Services.PLATFORM.getConfigDir().resolve("cursors_extended.json"), this);
    }

    public GlobalSettings getGlobal() {
        return this.global;
    }

    public boolean isCreativeTabsEnabled() {
        return this.creativeTabsEnabled;
    }

    public void setCreativeTabsEnabled(boolean creativeTabsEnabled) {
        this.creativeTabsEnabled = creativeTabsEnabled;
    }

    public boolean isEnchantmentsEnabled() {
        return this.enchantmentsEnabled;
    }

    public void setEnchantmentsEnabled(boolean enchantmentsEnabled) {
        this.enchantmentsEnabled = enchantmentsEnabled;
    }

    public boolean isStonecutterRecipesEnabled() {
        return this.stonecutterRecipesEnabled;
    }

    public void setStonecutterRecipesEnabled(boolean stonecutterRecipesEnabled) {
        this.stonecutterRecipesEnabled = stonecutterRecipesEnabled;
    }

    public boolean isLoomPatternsEnabled() {
        return this.loomPatternsEnabled;
    }

    public void setLoomPatternsEnabled(boolean loomPatternsEnabled) {
        this.loomPatternsEnabled = loomPatternsEnabled;
    }

    public boolean isWorldIconEnabled() {
        return this.worldIconEnabled;
    }

    public void setWorldIconEnabled(boolean worldIconEnabled) {
        this.worldIconEnabled = worldIconEnabled;
    }

    public boolean isItemSlotEnabled() {
        return this.itemSlotEnabled;
    }

    public void setItemSlotEnabled(boolean itemSlotEnabled) {
        this.itemSlotEnabled = itemSlotEnabled;
    }

    public boolean isItemGrabbingEnabled() {
        return this.itemGrabbingEnabled;
    }

    public void setItemGrabbingEnabled(boolean itemGrabbingEnabled) {
        this.itemGrabbingEnabled = itemGrabbingEnabled;
    }

    public boolean isAdvancementTabsEnabled() {
        return this.advancementTabsEnabled;
    }

    public void setAdvancementTabsEnabled(boolean advancementTabsEnabled) {
        this.advancementTabsEnabled = advancementTabsEnabled;
    }

    public boolean isServerIconEnabled() {
        return this.serverIconEnabled;
    }

    public void setServerIconEnabled(boolean serverIconEnabled) {
        this.serverIconEnabled = serverIconEnabled;
    }

    public boolean isAggressiveCursor() {
        return this.aggressiveCursor;
    }

    public void setAggressiveCursor(boolean aggressiveCursor) {
        this.aggressiveCursor = aggressiveCursor;
    }

    public boolean isVirtualMode() {
        return this.virtualMode;
    }

    public void setVirtualMode(boolean virtualMode) {
        this.virtualMode = virtualMode;
    }

    public boolean isLegacyMode() {
        return this.legacyMode;
    }

    public void setLegacyMode(boolean legacyMode) {
        this.legacyMode = legacyMode;
    }

    public boolean isHeldCursorsEnabled() {
        return this.heldCursorsEnabled;
    }

    public void setHeldCursorsEnabled(boolean heldCursorsEnabled) {
        this.heldCursorsEnabled = heldCursorsEnabled;
    }

    public boolean isPointerScrollbarEnabled() {
        return this.pointerScrollbarEnabled;
    }

    public void setPointerScrollbarEnabled(boolean pointerScrollbarEnabled) {
        this.pointerScrollbarEnabled = pointerScrollbarEnabled;
    }

    public boolean isResizeScrollbarEnabled() {
        return this.resizeScrollbarEnabled;
    }

    public void setResizeScrollbarEnabled(boolean resizeScrollbarEnabled) {
        this.resizeScrollbarEnabled = resizeScrollbarEnabled;
    }

    public boolean isShowHotspotGuide() {
        return this.showHotspotGuide;
    }

    public void setShowHotspotGuide(boolean showHotspotGuide) {
        this.showHotspotGuide = showHotspotGuide;
    }

    public boolean isRemapStandardCursors() {
        return this.workarounds && this.remapStandardCursors;
    }

    public void setRemapStandardCursors(boolean remapStandardCursors) {
        this.remapStandardCursors = remapStandardCursors;
    }

    public boolean isWorkaroundsEnabled() {
        return this.workarounds;
    }

    public void setWorkarounds(boolean workarounds) {
        this.workarounds = workarounds;
    }

    public static class GlobalSettings
    extends AbstractCursorSettings
    implements Serializable {
        private boolean scaleActive = false;
        private boolean xhotActive = false;
        private boolean yhotActive = false;

        private GlobalSettings() {
        }

        public void setActiveAll(boolean active) {
            this.setScaleActive(active);
            this.setXHotActive(active);
            this.setYHotActive(active);
        }

        public boolean isScaleActive() {
            return this.scaleActive;
        }

        public void setScaleActive(boolean scaleEnabled) {
            this.scaleActive = scaleEnabled;
        }

        public boolean isXHotActive() {
            return this.xhotActive;
        }

        public void setXHotActive(boolean xhotActive) {
            this.xhotActive = xhotActive;
        }

        public boolean isYHotActive() {
            return this.yhotActive;
        }

        public void setYHotActive(boolean yhotActive) {
            this.yhotActive = yhotActive;
        }

        public void setScale(float scale) {
            this.scale = SettingsUtil.sanitizeScale(scale);
        }

        public void setXHot(double xhot) {
            this.setXHot((int)xhot);
        }

        public void setXHot(int xhot) {
            this.xhot = Math.max(0, xhot);
        }

        @Override
        public int xhot() {
            return Math.max(0, this.xhot);
        }

        public void setYHot(double yhot) {
            this.setYHot((int)yhot);
        }

        public void setYHot(int yhot) {
            this.yhot = Math.max(0, yhot);
        }

        @Override
        public int yhot() {
            return Math.max(0, this.yhot);
        }

        @Override
        public boolean enabled() {
            throw new UnsupportedOperationException("GlobalSettings does not have an enabled setting");
        }

        @Override
        public Boolean animated() {
            throw new UnsupportedOperationException("GlobalSettings does not have an animated setting");
        }

        public CursorSettings apply(CursorSettings settings) {
            CursorSettings copied = settings.copy();
            copied.scale = this.isScaleActive() ? this.scale() : copied.scale();
            copied.xhot = this.isXHotActive() ? this.xhot() : copied.xhot();
            copied.yhot = this.isYHotActive() ? this.yhot() : copied.yhot();
            return copied;
        }
    }

    public static class CursorSettings
    extends AbstractCursorSettings
    implements Serializable {
        protected boolean enabled = true;
        protected Boolean animated = SettingsUtil.ANIMATED;

        public void setScale(float scale) {
            this.scale = SettingsUtil.sanitizeScale(scale);
        }

        public void setXHot(@NotNull Cursor cursor, int xhot) {
            this.xhot = SettingsUtil.sanitizeXHot(xhot, cursor);
        }

        public void setYHot(@NotNull Cursor cursor, int yhot) {
            this.yhot = SettingsUtil.sanitizeYHot(yhot, cursor);
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public boolean enabled() {
            return this.enabled;
        }

        @Override
        public Boolean animated() {
            return this.animated;
        }

        public void setAnimated(boolean animated) {
            this.animated = animated;
        }

        private void mergeCommon(CursorProperties metadata) {
            this.scale = SettingsUtil.sanitizeScale(metadata.scale());
            this.xhot = SettingsUtil.sanitizeHotspot(metadata.xhot(), Integer.MAX_VALUE);
            this.yhot = SettingsUtil.sanitizeHotspot(metadata.yhot(), Integer.MAX_VALUE);
            this.animated = metadata.animated();
        }

        public void mergeSelective(CursorProperties metadata) {
            if (this.enabled) {
                this.enabled = metadata.enabled();
            }
            this.mergeCommon(metadata);
        }

        public void mergeAll(CursorProperties metadata) {
            this.enabled = metadata.enabled();
            this.mergeCommon(metadata);
        }

        public CursorSettings copy() {
            CursorSettings settings = new CursorSettings();
            settings.scale = this.scale;
            settings.xhot = this.xhot;
            settings.yhot = this.yhot;
            settings.enabled = this.enabled;
            settings.animated = this.animated;
            return settings;
        }
    }

    public static abstract class AbstractCursorSettings
    implements CursorProperties {
        protected float scale = 1.0f;
        protected int xhot = 0;
        protected int yhot = 0;

        @Override
        public float scale() {
            return this.scale;
        }

        @Override
        public int xhot() {
            return this.xhot;
        }

        @Override
        public int yhot() {
            return this.yhot;
        }
    }
}

