/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.cursor;

import com.mojang.blaze3d.platform.cursor.CursorType;
import com.mojang.blaze3d.platform.cursor.CursorTypes;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorTypesExt;
import io.github.fishstiz.cursors_extended.lifecycle.ClientStartedListener;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.Nullable;

public class CursorRegistry
implements ClientStartedListener {
    private final Map<String, Cursor> registry = new Object2ObjectLinkedOpenHashMap();
    private final Map<String, Cursor> external = new Object2ObjectOpenHashMap();

    @Override
    public void onClientStarted(Minecraft minecraft) {
        this.register(CursorType.DEFAULT);
        this.registerAlias(CursorType.DEFAULT, CursorTypes.ARROW);
        this.register(CursorTypes.POINTING_HAND);
        this.register(CursorTypesExt.GRABBING);
        this.register(CursorTypes.IBEAM);
        this.register(CursorTypesExt.SHIFT);
        this.register(CursorTypesExt.BUSY);
        this.register(CursorTypes.NOT_ALLOWED);
        this.register(CursorTypes.CROSSHAIR);
        this.register(CursorTypes.RESIZE_ALL);
        this.register(CursorTypes.RESIZE_EW);
        this.register(CursorTypes.RESIZE_NS);
        this.register(CursorTypesExt.RESIZE_NWSE);
        this.register(CursorTypesExt.RESIZE_NESW);
    }

    public void register(CursorType cursorType) {
        this.registry.putIfAbsent(cursorType.toString(), new Cursor(cursorType));
    }

    public void registerAlias(CursorType cursorType, CursorType alias) {
        this.registry.putIfAbsent(alias.toString(), this.get(cursorType));
    }

    public Cursor get(CursorType cursorType) {
        Cursor cursor = this.registry.get(cursorType.toString());
        if (cursor == null) {
            return this.external.computeIfAbsent(cursorType.toString(), name -> {
                CursorsExtended.LOGGER.info("[cursors_extended] Found external cursor type: {}", (Object)cursorType);
                return new Cursor(cursorType);
            });
        }
        return cursor;
    }

    @Nullable
    public Cursor tryGet(String cursorType) {
        Cursor cursor = this.registry.get(cursorType);
        return cursor != null ? cursor : this.external.get(cursorType);
    }

    public Set<Cursor> getCursors() {
        ObjectOpenHashSet cursors = new ObjectOpenHashSet();
        cursors.addAll(this.registry.values());
        cursors.addAll(this.external.values());
        return cursors;
    }

    public Set<Cursor> getInternalCursors() {
        return new ObjectLinkedOpenHashSet(this.registry.values());
    }
}

