/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.widget;

import com.mojang.blaze3d.platform.cursor.CursorType;
import com.mojang.blaze3d.platform.cursor.CursorTypes;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.gui.MouseEvent;
import io.github.fishstiz.cursors_extended.gui.widget.CursorWidget;
import io.github.fishstiz.cursors_extended.gui.widget.SliderWidget;
import io.github.fishstiz.cursors_extended.util.DrawUtil;
import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CursorHotspotWidget
extends CursorWidget {
    private static final ResourceLocation BACKGROUND_128 = CursorsExtended.loc("textures/gui/background_128.png");
    private static final int BACKGROUND_DISABLED = -1358954496;
    private static final int RULER_COLOR = -65536;
    private static final int OVERRIDE_RULER_COLOR = -16711936;
    private static final Component OVERFLOW_TEXT = Component.translatable((String)"cursors_extended.options.image_too_large");
    private static final int OVERFLOW_COLOR = -1;
    private final SliderWidget xhotSlider;
    private final SliderWidget yhotSlider;
    @Nullable
    private final MouseEventListener mouseEventListener;
    private final int maxXHot;
    private final int maxYHot;
    private boolean dragging = false;

    public CursorHotspotWidget(@NotNull Cursor cursor, @NotNull SliderWidget xhotSlider, @NotNull SliderWidget yhotSlider, @Nullable MouseEventListener mouseEventListener) {
        super(CommonComponents.EMPTY, cursor, BACKGROUND_128);
        this.xhotSlider = xhotSlider;
        this.yhotSlider = yhotSlider;
        this.mouseEventListener = mouseEventListener;
        this.maxXHot = SettingsUtil.getMaxXHot(cursor);
        this.maxYHot = SettingsUtil.getMaxYHot(cursor);
    }

    @Override
    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.active = !this.isOverflowing() && (this.xhotSlider.isActive() || this.yhotSlider.isActive());
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        if (this.isHovered() && this.isOverflowing()) {
            Font font = Minecraft.getInstance().font;
            int textX = this.getX() + (this.getWidth() / 2 - font.width((FormattedText)OVERFLOW_TEXT) / 2);
            int n = this.getY();
            int n2 = this.getHeight() / 2;
            Objects.requireNonNull(font);
            int textY = n + (n2 - 9 / 2);
            guiGraphics.drawString(font, OVERFLOW_TEXT, textX, textY, -1);
        }
    }

    @Override
    protected void renderBackground(@NotNull GuiGraphics guiGraphics) {
        super.renderBackground(guiGraphics);
        if (!this.active) {
            guiGraphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), -1358954496);
        }
    }

    @Override
    protected void renderCursor(@NotNull GuiGraphics guiGraphics, @NotNull Cursor cursor) {
        DrawUtil.drawCursor(guiGraphics, cursor, this.getX(), this.getY(), this.getWidth());
    }

    @Override
    protected void renderRuler(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isOverflowing()) {
            return;
        }
        boolean isGlobalX = CursorsExtended.CONFIG.getGlobal().isXHotActive();
        boolean isGlobalY = CursorsExtended.CONFIG.getGlobal().isYHotActive();
        int colorX = isGlobalX ? -16711936 : -65536;
        int colorY = isGlobalY ? -16711936 : -65536;
        int xhot = this.clampHotspot(isGlobalX ? CursorsExtended.CONFIG.getGlobal().xhot() : (int)this.xhotSlider.getMappedValue(), this.maxXHot);
        int yhot = this.clampHotspot(isGlobalY ? CursorsExtended.CONFIG.getGlobal().yhot() : (int)this.yhotSlider.getMappedValue(), this.maxYHot);
        float rulerWidth = this.getCellWidth();
        float rulerHeight = this.getCellHeight();
        float xhotX1 = (float)this.getX() + (float)xhot * rulerWidth - (float)(!(rulerWidth > 1.0f) && xhot == this.maxXHot ? 1 : 0);
        float xhotX2 = (float)this.getX() + (float)xhot * rulerWidth + (xhot > 0 ? rulerWidth : Math.max(rulerWidth, 2.0f));
        float yhotY1 = (float)this.getY() + (float)yhot * rulerHeight - (float)(!(rulerHeight > 1.0f) && yhot == this.maxYHot ? 1 : 0);
        float yhotY2 = (float)this.getY() + (float)yhot * rulerHeight + (yhot > 0 ? rulerHeight : Math.max(rulerHeight, 2.0f));
        if (isGlobalX && !isGlobalY || isGlobalX == isGlobalY) {
            DrawUtil.fill(guiGraphics, this.getX(), yhotY1, this.getRight(), yhotY2, colorY);
            DrawUtil.fill(guiGraphics, xhotX1, this.getY(), xhotX2, this.getBottom(), colorX);
        } else {
            DrawUtil.fill(guiGraphics, xhotX1, this.getY(), xhotX2, this.getBottom(), colorX);
            DrawUtil.fill(guiGraphics, this.getX(), yhotY1, this.getRight(), yhotY2, colorY);
        }
    }

    public void onClick(MouseButtonEvent mouseButtonEvent, boolean doubleClick) {
        this.dragging = true;
        this.setHotspots(MouseEvent.CLICK, mouseButtonEvent.x(), mouseButtonEvent.y());
    }

    protected void onDrag(MouseButtonEvent mouseButtonEvent, double deltaX, double deltaY) {
        if (this.dragging) {
            this.setHotspots(MouseEvent.DRAG, mouseButtonEvent.x(), mouseButtonEvent.y());
        }
    }

    public void onRelease(MouseButtonEvent mouseButtonEvent) {
        if (this.dragging) {
            this.dragging = false;
            this.setHotspots(MouseEvent.RELEASE, mouseButtonEvent.x(), mouseButtonEvent.y());
            this.setFocused(false);
        }
    }

    public void setHotspots(MouseEvent mouseEvent, double mouseX, double mouseY) {
        int xhot = this.clampHotspot((int)((mouseX - (double)this.getX()) / (double)this.getCellWidth()), this.maxXHot);
        int yhot = this.clampHotspot((int)((mouseY - (double)this.getY()) / (double)this.getCellHeight()), this.maxYHot);
        if (this.xhotSlider.isActive()) {
            this.xhotSlider.applyMappedValue(xhot);
        }
        if (this.yhotSlider.isActive()) {
            this.yhotSlider.applyMappedValue(yhot);
        }
        if (this.mouseEventListener != null) {
            this.mouseEventListener.onMouseEvent(this, mouseEvent, xhot, yhot);
        }
    }

    private int clampHotspot(int hotspot, int max) {
        return SettingsUtil.clamp(hotspot, 0, max);
    }

    @Override
    public CursorType cursors_extended$cursorType(double mouseX, double mouseY) {
        boolean inYHot;
        if (!this.active) {
            return this.isHovered() ? CursorTypes.NOT_ALLOWED : CursorType.DEFAULT;
        }
        if (!this.dragging) {
            return this.isHovered() ? CursorTypes.CROSSHAIR : CursorType.DEFAULT;
        }
        boolean inXHot = !CursorsExtended.CONFIG.getGlobal().isXHotActive() && this.isInsideXHot(mouseX);
        boolean bl = inYHot = !CursorsExtended.CONFIG.getGlobal().isYHotActive() && this.isInsideYHot(mouseY);
        if (inXHot && inYHot) {
            return CursorTypes.RESIZE_ALL;
        }
        if (inXHot) {
            return CursorTypes.RESIZE_EW;
        }
        if (inYHot) {
            return CursorTypes.RESIZE_NS;
        }
        return CursorTypes.NOT_ALLOWED;
    }

    private boolean isInsideXHot(double mouseX) {
        double rawX = (mouseX - (double)this.getX()) / (double)this.getCellWidth();
        return rawX >= 0.0 && rawX <= (double)this.maxXHot;
    }

    private boolean isInsideYHot(double mouseY) {
        double rawY = (mouseY - (double)this.getY()) / (double)this.getCellHeight();
        return rawY >= 0.0 && rawY <= (double)this.maxYHot;
    }

    public static interface MouseEventListener {
        public void onMouseEvent(@NotNull CursorHotspotWidget var1, @NotNull MouseEvent var2, int var3, int var4);
    }
}

