/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.widget;

import com.mojang.blaze3d.platform.cursor.CursorType;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.gui.widget.CursorWidget;
import io.github.fishstiz.cursors_extended.resource.texture.AnimatedCursorTexture;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import io.github.fishstiz.cursors_extended.util.DrawUtil;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CursorPreviewWidget
extends CursorWidget {
    private static final ResourceLocation BACKGROUND_128 = CursorsExtended.loc("textures/gui/background_dark_128.png");
    private static final Component PREVIEW_TEXT = Component.translatable((String)"cursors_extended.options.preview");
    private static final int PREVIEW_TEXT_OFFSET = 4;
    private static final int PREVIEW_TEXT_COLOR = Integer.MAX_VALUE;
    private static final int RULER_COLOR = -16711936;
    private static final int BACKGROUND_DISABLED = 0x7F000000;
    private static final int BACKGROUND_OVERFLOW = -9803158;
    private static final int DEFAULT_BUTTON_SIZE = 20;
    @Nullable
    private final Button button;
    private final Font font;

    public CursorPreviewWidget(@NotNull Cursor cursor, @NotNull Font font, @Nullable Button button) {
        super(CommonComponents.EMPTY, cursor, BACKGROUND_128);
        this.active = false;
        this.font = font;
        this.button = button;
    }

    public CursorPreviewWidget(@NotNull Cursor cursor, @NotNull Font font) {
        this(cursor, font, Button.builder((Component)CommonComponents.EMPTY, b -> b.setFocused(false)).size(20, 20).build());
    }

    @Override
    protected void renderBackground(@NotNull GuiGraphics guiGraphics) {
        super.renderBackground(guiGraphics);
        if (this.isOverflowing()) {
            guiGraphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), -9803158);
        }
    }

    @Override
    protected void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Cursor cursor = this.getCursor();
        if (cursor.hasTexture()) {
            this.renderBackground(guiGraphics);
            if (cursor.isTextureEnabled()) {
                this.renderPreviewText(guiGraphics);
                this.renderTestButton(guiGraphics, mouseX, mouseY, partialTick);
                this.renderRuler(guiGraphics, mouseX, mouseY);
            }
        }
        if (!cursor.isTextureEnabled()) {
            guiGraphics.fill(this.getX(), this.getY(), this.getRight(), this.getBottom(), 0x7F000000);
        }
        this.renderBorder(guiGraphics);
        if (this.isHovered()) {
            guiGraphics.requestCursor(this.cursors_extended$cursorType(mouseX, mouseY));
        }
    }

    protected void renderPreviewText(@NotNull GuiGraphics guiGraphics) {
        int width = this.font.width((FormattedText)PREVIEW_TEXT);
        int endX = this.getRight() - 4;
        int endY = this.getBottom() - 4;
        int startX = endX - width;
        Objects.requireNonNull(this.font);
        int startY = endY - 9;
        DrawUtil.drawScrollableTextLeftAlign(guiGraphics, this.font, PREVIEW_TEXT, startX, startY, endX, endY, Integer.MAX_VALUE, false);
    }

    protected void renderTestButton(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.button != null) {
            int buttonX = this.getX() + (this.getWidth() / 2 - this.button.getWidth() / 2);
            int buttonY = this.getY() + (this.getHeight() / 2 - this.button.getHeight() / 2);
            this.button.setPosition(buttonX, buttonY);
            this.button.render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    protected void renderRuler(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isRenderRuler() && this.isMouseOver(mouseX, mouseY)) {
            guiGraphics.hLine(this.getX(), this.getRight() - 1, mouseY, -16711936);
            guiGraphics.vLine(mouseX, this.getY(), this.getBottom(), -16711936);
        }
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean doubleClicked) {
        CursorTexture cursorTexture;
        if (this.button != null && this.button.isMouseOver(mouseButtonEvent.x(), mouseButtonEvent.y()) && this.button.mouseClicked(mouseButtonEvent, doubleClicked) && (cursorTexture = this.getCursor().getTexture()) instanceof AnimatedCursorTexture) {
            AnimatedCursorTexture animatedCursorTexture = (AnimatedCursorTexture)cursorTexture;
            animatedCursorTexture.restartAnimation();
        }
        return false;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return this.visible && mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)this.getRight() && mouseY < (double)this.getBottom();
    }

    @Override
    protected float getCellWidth() {
        return this.getHeight() != this.getWidth() ? Math.max(super.getCellHeight(), super.getCellWidth()) : super.getCellWidth();
    }

    @Override
    protected float getCellHeight() {
        return this.getHeight() != this.getWidth() ? Math.max(super.getCellHeight(), super.getCellWidth()) : super.getCellHeight();
    }

    @Override
    public CursorType cursors_extended$cursorType(double mouseX, double mouseY) {
        return this.getCursor().cursorType();
    }
}

