/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursor.resolver;

import io.github.fishstiz.minecraftcursor.cursor.CursorManager;
import io.github.fishstiz.minecraftcursor.cursor.resolver.ElementInspector;
import io.github.fishstiz.minecraftcursor.cursor.resolver.ElementWalker;
import io.github.fishstiz.minecraftcursor.platform.Services;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ElementInspectorImpl
implements ElementInspector {
    private static final float TEXT_SCALE = 0.75f;
    private static final float Z = 2000.0f;
    private final class_2561 screenLabel = class_2561.method_43470((String)"S: ").method_27694(style -> style.method_36139(-13394945));
    private final class_2561 cacheLabel = class_2561.method_43470((String)"Cache: ").method_27694(style -> style.method_36139(-1));
    private final class_2561 deepestLabel = class_2561.method_43470((String)"D: ").method_27694(style -> style.method_36139(-16711936));
    private final class_2561 processedLabel = class_2561.method_43470((String)"P: ").method_27694(style -> style.method_36139(-65536));
    private final class_2561 virtualModeLabel = class_2561.method_43470((String)"Virtual Mode: ").method_27692(class_124.field_1065);
    private Set<Class<?>> cache = new ObjectOpenHashSet();
    private class_2561 cacheText = class_2561.method_43473();
    private class_364 processed;
    private String processedName;
    private boolean enabled = true;

    ElementInspectorImpl() {
    }

    @Override
    public boolean isInspecting() {
        return this.enabled;
    }

    @Override
    public void destroy() {
        this.enabled = false;
        this.cache.clear();
        this.cache = null;
        this.cacheText = null;
        this.processed = null;
        this.processedName = null;
    }

    @Override
    public boolean setProcessed(class_364 processed, boolean cached) {
        this.processed = processed;
        this.processedName = this.getClassName(processed);
        if (cached) {
            this.cache.add(processed.getClass());
            this.cacheText = this.cacheLabel.method_27661().method_27693(String.valueOf(this.cache.size()));
        }
        return true;
    }

    @Override
    public void render(class_310 minecraft, @NotNull class_437 screen, class_332 guiGraphics, double mouseX, double mouseY) {
        if (this.enabled) {
            class_8030 screenRectangle = this.getBounds((class_364)screen);
            this.renderScreenName(minecraft, screen, screenRectangle, guiGraphics);
            this.renderCacheSize(minecraft, screenRectangle, guiGraphics);
            this.renderProcessed(minecraft, this.renderDeepest(minecraft, screen, guiGraphics, mouseX, mouseY), guiGraphics);
            this.renderVirtualInfo(minecraft, screenRectangle, guiGraphics);
        }
    }

    private class_8030 renderDeepest(class_310 minecraft, class_437 screen, class_332 guiGraphics, double mouseX, double mouseY) {
        class_364 child = ElementWalker.findDeepest((class_4069)screen, mouseX, mouseY);
        class_364 inspect = child != null ? child : screen;
        class_8030 bounds = this.getBounds(inspect);
        class_5250 label = this.deepestLabel.method_27661().method_27693(this.getClassName(inspect));
        this.renderInfo(minecraft, guiGraphics, bounds, (class_2561)label, Position.TOP_LEFT, true);
        return bounds;
    }

    private void renderProcessed(class_310 minecraft, class_8030 container, class_332 guiGraphics) {
        if (this.processed != null) {
            class_5250 label = this.processedLabel.method_27661().method_27693(this.processedName);
            class_8030 bounds = this.getBounds(this.processed);
            int index = bounds.method_49618() != container.method_49618() ? 0 : 1;
            this.renderInfo(minecraft, guiGraphics, bounds, (class_2561)label, Position.TOP_LEFT, index, true);
        }
    }

    private void renderScreenName(class_310 minecraft, class_437 screen, class_8030 bounds, class_332 guiGraphics) {
        class_5250 label = this.screenLabel.method_27661().method_27693(this.getClassName((class_364)screen));
        this.renderInfo(minecraft, guiGraphics, bounds, (class_2561)label, Position.BOTTOM_RIGHT, false);
    }

    private void renderCacheSize(class_310 minecraft, class_8030 screenBounds, class_332 guiGraphics) {
        this.renderInfo(minecraft, guiGraphics, screenBounds, this.cacheText, Position.BOTTOM_RIGHT, -1, false);
    }

    private void renderVirtualInfo(class_310 minecraft, class_8030 screenBounds, class_332 guiGraphics) {
        class_5250 virtualMode = this.virtualModeLabel.method_27661().method_10852(CursorManager.INSTANCE.isVirtual() ? class_5244.field_24332 : class_5244.field_24333);
        this.renderInfo(minecraft, guiGraphics, screenBounds, (class_2561)virtualMode, Position.TOP_RIGHT, false);
    }

    private void renderInfo(class_310 minecraft, class_332 guiGraphics, class_8030 bounds, class_2561 label, Position pos, boolean outline) {
        this.renderInfo(minecraft, guiGraphics, bounds, label, pos, 0, outline);
    }

    private void renderInfo(class_310 minecraft, class_332 guiGraphics, class_8030 bounds, class_2561 label, Position pos, int index, boolean outline) {
        class_5251 textColor = label.method_10866().method_10973();
        int color = 0xFF000000 | (textColor != null ? textColor.method_27716() : -1);
        int textX = pos.getX(minecraft, bounds, label, 0.75f);
        int textY = pos.getY(minecraft, bounds, index, 0.75f);
        class_4587 poseStack = guiGraphics.method_51448();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 2000.0f);
        if (outline) {
            guiGraphics.method_49601(bounds.method_49620(), bounds.method_49618(), bounds.comp_1196(), bounds.comp_1197(), color);
        }
        poseStack.method_46416(0.75f, 0.75f, 0.0f);
        poseStack.method_22905(0.75f, 0.75f, 0.0f);
        guiGraphics.method_27535(minecraft.field_1772, label, textX, textY, color);
        poseStack.method_22909();
    }

    private class_8030 getBounds(@Nullable class_364 element) {
        if (element instanceof class_8021) {
            class_8021 layoutElement = (class_8021)element;
            return layoutElement.method_48202();
        }
        return element != null ? element.method_48202() : class_8030.method_48248();
    }

    private String getClassName(class_364 element) {
        String namespace = Services.PLATFORM.isDevelopmentEnvironment() ? "named" : "intermediary";
        return Services.PLATFORM.unmapClassName(namespace, element.getClass().getName());
    }

    public static enum Position {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

        private static final int PADDING = 2;

        public int getX(class_310 minecraft, class_8030 bounds, class_2561 text, float scale) {
            int screenWidth = minecraft.method_22683().method_4486();
            int textWidth = minecraft.field_1772.method_27525((class_5348)text);
            int x = switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case TOP_LEFT, BOTTOM_LEFT -> (int)((float)(bounds.method_49620() + 2) / scale);
                case TOP_RIGHT, BOTTOM_RIGHT -> {
                    int unscaledX = bounds.method_49620() + bounds.comp_1196() - (int)((float)textWidth * scale) - 2;
                    yield (int)((float)unscaledX / scale);
                }
            };
            if ((float)(x + textWidth) * scale > (float)screenWidth && (x = (int)(((float)screenWidth - (float)textWidth * scale - 2.0f) / scale)) < 0) {
                x = 0;
            }
            return x;
        }

        public int getY(class_310 minecraft, class_8030 bounds, int index, float scale) {
            int screenHeight = minecraft.method_22683().method_4502();
            Objects.requireNonNull(minecraft.field_1772);
            int textHeight = 9;
            int offsetY = index * textHeight;
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case TOP_LEFT, TOP_RIGHT -> (int)((float)(bounds.method_49618() + 2 + offsetY) / scale);
                case BOTTOM_LEFT, BOTTOM_RIGHT -> bounds.comp_1197() == 0 && bounds.comp_1196() == 0 ? (int)((float)(screenHeight - textHeight - 2 - offsetY) / scale) : (int)((float)(bounds.method_49618() - 2 + Math.max(0, bounds.comp_1197() - textHeight) + offsetY) / scale);
            };
        }
    }
}

