/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.config.Config;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.CursorAnimationHelper;
import io.github.fishstiz.minecraftcursor.gui.MouseEvent;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SliderWidget;
import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5244;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CursorHotspotWidget
extends CursorWidget {
    private static final class_2960 BACKGROUND_64 = MinecraftCursor.loc("textures/gui/background_128.png");
    private static final int BACKGROUND_DISABLED = -1358954496;
    private static final int RULER_COLOR = -65536;
    private static final int OVERRIDE_RULER_COLOR = -16711936;
    private final Config.GlobalSettings global = MinecraftCursor.CONFIG.getGlobal();
    private final CursorAnimationHelper animationHelper;
    private final SliderWidget xhotSlider;
    private final SliderWidget yhotSlider;
    @Nullable
    private final MouseEventListener mouseEventListener;
    private final int maxHotspot;
    private boolean renderRuler = true;
    private boolean dragging = false;

    public CursorHotspotWidget(@NotNull Cursor cursor, @NotNull CursorAnimationHelper animationHelper, @NotNull SliderWidget xhotSlider, @NotNull SliderWidget yhotSlider, @Nullable MouseEventListener mouseEventListener) {
        super(class_5244.field_39003, cursor, BACKGROUND_64);
        this.animationHelper = animationHelper;
        this.xhotSlider = xhotSlider;
        this.yhotSlider = yhotSlider;
        this.mouseEventListener = mouseEventListener;
        this.maxHotspot = SettingsUtil.getMaxHotspot(cursor);
    }

    @Override
    protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.field_22763 = this.xhotSlider.method_37303() || this.yhotSlider.method_37303();
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    protected void renderBackground(@NotNull class_332 guiGraphics) {
        super.renderBackground(guiGraphics);
        if (!this.field_22763) {
            guiGraphics.method_25294(this.method_46426(), this.method_46427(), this.getRight(), this.getBottom(), -1358954496);
        }
    }

    @Override
    protected void renderCursor(@NotNull class_332 guiGraphics, @NotNull Cursor cursor) {
        this.animationHelper.drawSprite(guiGraphics, cursor, this.method_46426(), this.method_46427(), this.method_25368());
    }

    @Override
    protected void renderRuler(@NotNull class_332 guiGraphics, int mouseX, int mouseY) {
        if (!this.renderRuler) {
            return;
        }
        boolean isGlobalX = this.global.isXHotActive();
        boolean isGlobalY = this.global.isYHotActive();
        int colorX = isGlobalX ? -16711936 : -65536;
        int colorY = isGlobalY ? -16711936 : -65536;
        int xhot = this.clampHotspot(isGlobalX ? this.global.getXHot() : (int)this.xhotSlider.getMappedValue());
        int yhot = this.clampHotspot(isGlobalY ? this.global.getYHot() : (int)this.yhotSlider.getMappedValue());
        float rulerSize = this.getCellSize();
        int xhotX1 = (int)((float)this.method_46426() + (float)xhot * rulerSize - (float)(!(rulerSize > 1.0f) && xhot == this.maxHotspot ? 1 : 0));
        int xhotX2 = (int)((float)this.method_46426() + (float)xhot * rulerSize + (xhot > 0 ? rulerSize : Math.max(rulerSize, 2.0f)));
        int yhotY1 = (int)((float)this.method_46427() + (float)yhot * rulerSize - (float)(!(rulerSize > 1.0f) && yhot == this.maxHotspot ? 1 : 0));
        int yhotY2 = (int)((float)this.method_46427() + (float)yhot * rulerSize + (yhot > 0 ? rulerSize : Math.max(rulerSize, 2.0f)));
        if (isGlobalX && !isGlobalY || isGlobalX == isGlobalY) {
            guiGraphics.method_25294(this.method_46426(), yhotY1, this.getRight(), yhotY2, colorY);
            guiGraphics.method_25294(xhotX1, this.method_46427(), xhotX2, this.getBottom(), colorX);
        } else {
            guiGraphics.method_25294(xhotX1, this.method_46427(), xhotX2, this.getBottom(), colorX);
            guiGraphics.method_25294(this.method_46426(), yhotY1, this.getRight(), yhotY2, colorY);
        }
    }

    public void setRenderRuler(boolean renderRuler) {
        this.renderRuler = renderRuler;
    }

    public void method_25348(double mouseX, double mouseY) {
        this.dragging = true;
        this.setHotspots(MouseEvent.CLICK, mouseX, mouseY);
    }

    protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (this.dragging) {
            this.setHotspots(MouseEvent.DRAG, mouseX, mouseY);
        }
    }

    public void method_25357(double mouseX, double mouseY) {
        if (this.dragging) {
            this.dragging = false;
            this.setHotspots(MouseEvent.RELEASE, mouseX, mouseY);
            this.method_25365(false);
        }
    }

    public void setHotspots(MouseEvent mouseEvent, double mouseX, double mouseY) {
        float cellSize = this.getCellSize();
        int xhot = this.clampHotspot((int)((mouseX - (double)this.method_46426()) / (double)cellSize));
        int yhot = this.clampHotspot((int)((mouseY - (double)this.method_46427()) / (double)cellSize));
        if (this.xhotSlider.method_37303()) {
            this.xhotSlider.applyMappedValue(xhot);
        }
        if (this.yhotSlider.method_37303()) {
            this.yhotSlider.applyMappedValue(yhot);
        }
        if (this.mouseEventListener != null) {
            this.mouseEventListener.onMouseEvent(this, mouseEvent, xhot, yhot);
        }
    }

    private int clampHotspot(int hotspot) {
        return SettingsUtil.clamp(hotspot, 0, this.maxHotspot);
    }

    public CursorType getCursorType(double mouseX, double mouseY) {
        if (!this.field_22763) {
            return CursorType.DEFAULT;
        }
        if (this.dragging) {
            return CursorType.GRABBING;
        }
        return CursorType.POINTER;
    }

    public static interface MouseEventListener {
        public void onMouseEvent(@NotNull CursorHotspotWidget var1, @NotNull MouseEvent var2, int var3, int var4);
    }
}

