/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

public abstract class CursorWidget
extends class_339
implements CursorProvider {
    public static final int DEFAULT_HEIGHT = 32;
    public static final int DEFAULT_WIDTH = 32;
    private static final int BACKGROUND_SIZE = 128;
    private static final int BORDER_COLOR = -16777216;
    private static final int FOCUSED_BORDER_COLOR = -1;
    private final class_2960 background128;
    private final Cursor cursor;

    protected CursorWidget(int x, int y, int width, int height, @NotNull class_2561 message, @NotNull Cursor cursor, @NotNull class_2960 background128) {
        super(x, y, width, height, message);
        this.cursor = cursor;
        this.background128 = background128;
    }

    protected CursorWidget(@NotNull class_2561 message, @NotNull Cursor cursor, @NotNull class_2960 background128) {
        this(0, 0, 32, 32, message, cursor, background128);
    }

    protected void renderCursor(@NotNull class_332 guiGraphics, @NotNull Cursor cursor) {
    }

    protected abstract void renderRuler(@NotNull class_332 var1, int var2, int var3);

    protected void renderBackground(@NotNull class_332 guiGraphics) {
        DrawUtil.drawCheckerboard(guiGraphics, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), this.getCellSize(), this.background128, 128);
    }

    protected void renderBorder(@NotNull class_332 guiGraphics) {
        int color = this.method_25370() && this.field_22763 ? -1 : -16777216;
        guiGraphics.method_49601(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), color);
    }

    protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.cursor.isLoaded()) {
            this.renderBackground(guiGraphics);
            this.renderCursor(guiGraphics, this.cursor);
            this.renderRuler(guiGraphics, mouseX, mouseY);
        }
        this.renderBorder(guiGraphics);
    }

    @NotNull
    protected Cursor getCursor() {
        return this.cursor;
    }

    protected float getCellSize() {
        Cursor currentCursor = this.getCursor();
        return currentCursor.isLoaded() ? (float)this.method_25368() / (float)this.getCursor().getTextureWidth() : 0.0f;
    }

    public void setHeight(int height) {
        this.field_22759 = height;
    }

    public int getRight() {
        return this.method_46426() + this.method_25368();
    }

    public int getBottom() {
        return this.method_46427() + this.method_25364();
    }

    protected void method_47399(@NotNull class_6382 narrationElementOutput) {
        narrationElementOutput.method_37034(class_6381.field_33788, (class_2561)this.method_25360());
    }
}

