package io.github.fishstiz.cursors_extended.compat;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import net.minecraft.class_1041;
import net.minecraft.class_11875;
import org.jetbrains.annotations.Nullable;

public interface CursorStateTracker {
    CursorStateTracker DEFAULT = new CursorStateTracker() {
    };

    default void trackCursor(ModCursor cursor) {
        CursorStateTrackerImpl.get().trackCursor(cursor);
    }

    default void untrackCursor(ModCursor cursor) {
    }

    default boolean isTracking() {
        return false;
    }

    default void resetCursor(long window, String source) {
        CursorStateTrackerImpl.get().resetCursor(window, source);
    }

    default void setCursor(long window, ModCursor cursor) {
        CursorStateTrackerImpl.get().setCursor(window, cursor);
    }

    default @Nullable ModCursor getCursor(long handle) {
        return null;
    }

    default class_11875 getCurrentCursor(long window) {
        return class_11875.field_62449;
    }

    static CursorStateTracker get() {
        return CursorStateTrackerImpl.getOrDefault();
    }

    static StackWalker getStackWalker() {
        return CursorStateTrackerImpl.getStackWalker();
    }

    static void syncWithMinecraft(long window, class_11875 cursorType) {
        class_1041 minecraftWindow = CursorsExtended.getInstance().getDisplay().getWindow();
        if (window == minecraftWindow.method_4490()) {
            minecraftWindow.field_62448 = cursorType;
        }
    }
}
