package io.github.fishstiz.cursors_extended.cursor;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import net.minecraft.class_11875;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

public final class Cursor {
    private final class_11875 cursorType;
    private boolean lazy = true;

    public Cursor(class_11875 cursorType) {
        this.cursorType = cursorType;
    }

    public long handle() {
        if (isEnabled()) {
            CursorTexture texture = getTexture();
            if (texture != null && texture.handle() != MemoryUtil.NULL) {
                return texture.handle();
            }
        }
        return cursorType.field_62451;
    }

    public String name() {
        return cursorType.toString();
    }

    public @Nullable CursorTexture getTexture() {
        return texturedCursorType().cursors_extended$getTexture();
    }

    public void setTexture(CursorTexture texture) {
        texturedCursorType().cursors_extended$setTexture(texture);
    }

    public boolean hasTexture() {
        return getTexture() != null;
    }

    public boolean isEnabled() {
        return CursorsExtended.CONFIG.getOrCreateSettings(this).enabled();
    }

    public boolean isTextureEnabled() {
        return hasTexture() && isEnabled();
    }

    public class_11875 cursorType() {
        return cursorType;
    }

    public void prepareReload() {
        this.lazy = true;
    }

    public void reloaded() {
        this.lazy = false;
    }

    public boolean isLazy() {
        return lazy;
    }

    public class_2561 text() {
        return class_2561.method_43471("cursors_extended.options.cursor-type." + name());
    }

    private TexturedCursorType texturedCursorType() {
        return (TexturedCursorType) cursorType;
    }
}
