package io.github.fishstiz.cursors_extended.cursor;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.lifecycle.ClientStartedListener;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import java.util.Set;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import net.minecraft.class_310;

public class CursorRegistry implements ClientStartedListener {
    private final Map<String, Cursor> registry = new Object2ObjectLinkedOpenHashMap<>();
    private final Map<String, Cursor> external = new Object2ObjectOpenHashMap<>();

    @Override
    public void onClientStarted(class_310 minecraft) {
        register(class_11875.field_62449);
        registerAlias(class_11875.field_62449, class_11876.field_62452);
        register(class_11876.field_62455);
        register(CursorTypesExt.GRABBING);
        register(class_11876.field_62453);
        register(CursorTypesExt.SHIFT);
        register(CursorTypesExt.BUSY);
        register(class_11876.field_62459);
        register(class_11876.field_62454);
        register(class_11876.field_62458);
        register(class_11876.field_62457);
        register(class_11876.field_62456);
        register(CursorTypesExt.RESIZE_NWSE);
        register(CursorTypesExt.RESIZE_NESW);
    }

    public void register(class_11875 cursorType) {
        registry.putIfAbsent(cursorType.toString(), new Cursor(cursorType));
    }

    public void registerAlias(class_11875 cursorType, class_11875 alias) {
        registry.putIfAbsent(alias.toString(), get(cursorType));
    }

    public Cursor get(class_11875 cursorType) {
        Cursor cursor = registry.get(cursorType.toString());

        if (cursor == null) {
            return external.computeIfAbsent(cursorType.toString(), name -> {
                CursorsExtended.LOGGER.info("[cursors_extended] Found external cursor type: {}", cursorType);
                return new Cursor(cursorType);
            });
        }

        return cursor;
    }

    public @Nullable Cursor tryGet(String cursorType) {
        Cursor cursor = registry.get(cursorType);
        return cursor != null ? cursor : external.get(cursorType);
    }

    public Set<Cursor> getCursors() {
        Set<Cursor> cursors = new ObjectOpenHashSet<>();
        cursors.addAll(registry.values());
        cursors.addAll(external.values());
        return cursors;
    }

    public Set<Cursor> getInternalCursors() {
        return new ObjectLinkedOpenHashSet<>(registry.values());
    }
}
