package io.github.fishstiz.cursors_extended.gui.widget;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.util.DrawUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_7919;

public class OptionsListWidget extends AbstractListWidget<OptionsListWidget.AbstractEntry> {
    private static final int BACKGROUND_PADDING_Y = 2;
    private static final int SEARCH_HIGHLIGHT_COLOR = 0x66FFD700; // 40% yellow
    private final ElementSlidingBackground hoveredBackground = new ElementSlidingBackground(0x26FFFFFF); // 15% white
    private final class_327 font;
    private @NotNull String search = "";

    public OptionsListWidget(class_310 minecraft, class_327 font, int itemHeight, int spacing) {
        super(minecraft, 0, 0, 0, itemHeight, spacing);

        this.font = font;
    }

    public OptionsListWidget(class_310 minecraft, class_327 font, int spacing) {
        this(minecraft, font, class_4185.field_39501, spacing);
    }

    public void addWidget(class_339 widget) {
        this.method_25321(new WidgetEntry(widget));
    }

    public void addToggle(
            boolean value,
            Boolean defaultValue,
            @NotNull Consumer<Boolean> onToggle,
            @NotNull class_2561 label,
            @Nullable class_7919 tooltip,
            BooleanSupplier active
    ) {
        this.method_25321(new ToggleEntry(value, defaultValue, onToggle, label, null, tooltip, active));
    }

    public void addToggle(
            boolean value,
            Boolean defaultValue,
            @NotNull Consumer<Boolean> onToggle,
            @NotNull class_2561 label,
            @Nullable class_7919 tooltip,
            boolean active
    ) {
        this.method_25321(new ToggleEntry(value, defaultValue, onToggle, label, null, tooltip, () -> active));
    }

    public void addToggle(
            boolean value,
            @NotNull Consumer<Boolean> onToggle,
            @NotNull class_2561 label,
            @Nullable class_7919 tooltip,
            boolean active
    ) {
        this.addToggle(value, null, onToggle, label, tooltip, active);
    }

    public void addToggle(
            boolean value,
            @NotNull Consumer<Boolean> onToggle,
            @NotNull class_2561 label,
            @Nullable Prefix prefix,
            @Nullable class_7919 tooltip,
            boolean active
    ) {
        this.method_25321(new ToggleEntry(value, onToggle, label, prefix, tooltip, active));
    }

    public void addToggleableSlider(
            @NotNull SliderWidget slider,
            boolean value,
            @NotNull Consumer<Boolean> onToggle,
            @Nullable class_7919 tooltip
    ) {
        this.method_25321(new ToggleableSliderEntry(slider, value, onToggle, tooltip, true));
    }

    public void search(@NotNull String search) {
        this.search = search.toLowerCase();

        if (!this.search.isEmpty()) {
            AbstractEntry bestMatch = null;
            for (AbstractEntry entry : this.method_25396()) {
                String label = entry.indexedLabel;
                if (label.startsWith(this.search)) {
                    bestMatch = entry;
                    break;
                }
                if (bestMatch == null && label.contains(this.search)) {
                    bestMatch = entry;
                }
            }
            if (bestMatch != null) {
                this.method_73377(bestMatch);
            }
        }
    }

    private int computeBackgroundX(AbstractEntry entry) {
        return entry.method_46426() - this.rowGap;
    }

    private int computeBackgroundY(AbstractEntry entry) {
        return entry.method_46427() - BACKGROUND_PADDING_Y;
    }

    private int computeBackgroundWidth(AbstractEntry entry) {
        return entry.method_25368() + this.rowGap + (this.method_44392() ? field_55258 : BACKGROUND_PADDING_Y);
    }

    private int computeBackgroundHeight(AbstractEntry entry) {
        return entry.method_25364() + BACKGROUND_PADDING_Y * 2;
    }

    protected void renderSearchBackground(@NotNull class_332 guiGraphics) {
        if (!this.search.isEmpty()) {
            for (AbstractEntry entry : this.method_25396()) {
                if (entry.indexedLabel.contains(this.search)) {
                    int bgX = this.computeBackgroundX(entry);
                    int bgY = this.computeBackgroundY(entry);
                    int bgWidth = this.computeBackgroundWidth(entry);
                    int bgHeight = this.computeBackgroundHeight(entry);

                    guiGraphics.method_25294(bgX, bgY, bgX + bgWidth, bgY + bgHeight, SEARCH_HIGHLIGHT_COLOR);
                }
            }
        }
    }

    protected void renderEntryBackground(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int minX = this.method_46426() - this.rowGap;
        int minY = this.method_46427() - BACKGROUND_PADDING_Y;
        int maxX = this.method_55442() + field_55258;
        int maxY = this.method_55443() + BACKGROUND_PADDING_Y;
        guiGraphics.method_44379(minX, minY, maxX, maxY);

        this.renderSearchBackground(guiGraphics);

        AbstractEntry entry = this.method_25308(mouseX, mouseY);
        if (entry == null) {
            this.hoveredBackground.reset();
        } else {
            int x = this.computeBackgroundX(entry);
            int y = this.computeBackgroundY(entry);
            int width = this.computeBackgroundWidth(entry);
            int height = this.computeBackgroundHeight(entry);
            this.hoveredBackground.render(guiGraphics, x, y, width, height, partialTick);
        }

        guiGraphics.method_44380();
    }

    @Override
    public void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderEntryBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
    }

    @Override
    protected void method_57715(@NotNull class_332 guiGraphics) {
        // remove background
    }

    @Override
    protected void method_57713(@NotNull class_332 guiGraphics) {
        // remove separators
    }

    protected abstract class AbstractEntry extends AbstractListWidget<AbstractEntry>.Entry {
        protected final class_2561 label;
        private final String indexedLabel;
        private final List<class_339> children = new ArrayList<>();

        protected AbstractEntry(class_2561 label) {
            this.label = label;
            this.indexedLabel = label.getString().toLowerCase();
        }

        @Override
        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            for (class_339 child : this.children) {
                child.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            }
        }

        protected <T extends class_339> T addChild(T child) {
            this.children.add(child);
            return child;
        }

        @Override
        public @NotNull List<class_339> method_25396() {
            return this.children;
        }

        @Override
        public @NotNull List<class_339> method_37025() {
            return this.children;
        }
    }

    private class WidgetEntry extends AbstractEntry {
        private final class_339 widget;

        private WidgetEntry(@NotNull class_339 widget) {
            super(widget.method_25369());

            this.widget = this.addChild(widget);
        }

        @Override
        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            this.widget.method_55445(field_22758, this.method_25364());
            this.widget.method_48229(this.method_46426(), this.method_46427());
            super.method_25343(guiGraphics, mouseX, mouseY, hovered, partialTick);
        }
    }

    private class ToggleEntry extends AbstractEntry {
        protected static final class_2960 UNDO_ICON = CursorsExtended.loc("textures/gui/sprites/icon/arrow_u_turn_up_left.png");
        protected static final int BUTTON_WIDTH = 40;
        private static final int LABEL_COLOR = 0xFFFFFFFF; // white
        private static final int DISABLED_COLOR = 0xFFAAAAAA; // gray
        private final ButtonWidget button;
        private final ButtonWidget resetButton;
        private final Boolean defaultValue;
        private final Consumer<Boolean> onToggle;
        private final @Nullable Prefix prefix;
        private final BooleanSupplier active;
        protected boolean value;

        private ToggleEntry(
                boolean value,
                Boolean defaultValue,
                @NotNull Consumer<Boolean> onToggle,
                @NotNull class_2561 label,
                @Nullable Prefix prefix,
                @Nullable class_7919 tooltip,
                BooleanSupplier active
        ) {
            super(label);

            this.value = value;
            this.onToggle = onToggle;
            this.active = active;
            this.button = new ButtonWidget(
                    this.getRight() - BUTTON_WIDTH,
                    this.method_46427(),
                    BUTTON_WIDTH,
                    class_4185.field_39501,
                    value ? class_5244.field_24332 : class_5244.field_24333,
                    this::onPress
            );
            this.button.method_47400(tooltip);
            this.button.field_22763 = active.getAsBoolean();

            this.prefix = prefix;
            this.defaultValue = defaultValue;

            if (this.defaultValue != null) {
                this.resetButton = new ButtonWidget(class_2561.method_43473(), btn -> {
                    this.value = this.defaultValue;
                    this.updateMessage();
                    this.onToggle.accept(this.defaultValue);
                }).withSize(class_4185.field_39501).spriteOnly(UNDO_ICON);
                this.resetButton.field_22763 = this.button.field_22763 && this.value != this.defaultValue;
                this.addChild(this.resetButton);
            } else {
                this.resetButton = null;
            }

            this.addChild(this.button);
        }

        private ToggleEntry(
                boolean value,
                @NotNull Consumer<Boolean> onToggle,
                @NotNull class_2561 label,
                @Nullable Prefix prefix,
                @Nullable class_7919 tooltip,
                boolean active
        ) {
            this(value, null, onToggle, label, prefix, tooltip, () -> active);
        }

        protected void updateMessage() {
            this.button.method_25355(this.value ? class_5244.field_24332 : class_5244.field_24333);
        }

        protected void onPress(class_4185 button) {
            this.value = !this.value;
            this.updateMessage();
            this.onToggle.accept(this.value);
        }

        protected void renderLabel(@NotNull class_332 guiGraphics) {
            int marginX = 0;

            if (this.prefix != null) {
                marginX = this.prefix.render(guiGraphics, OptionsListWidget.this.font, this.method_46426(), this.method_46427(), this.method_25364());
                if (marginX > 0) marginX += OptionsListWidget.this.rowGap;
            }

            int startX = this.method_46426() + marginX;
            int startY = this.method_46427();
            int endX = this.button.method_46426() - OptionsListWidget.this.rowGap;
            int endY = this.getBottom();
            int color = this.active.getAsBoolean() && this.value ? LABEL_COLOR : DISABLED_COLOR;
            DrawUtil.drawScrollableTextLeftAlign(guiGraphics, OptionsListWidget.this.font, this.label, startX, startY, endX, endY, color);
        }

        @Override
        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            this.button.field_22763 = this.active.getAsBoolean();
            int right = this.getRight();

            if (this.resetButton != null) {
                this.resetButton.field_22763 = this.button.field_22763 && this.value != this.defaultValue;
                this.resetButton.method_48229(right - this.resetButton.method_25368(), this.method_46427());
                right -= this.resetButton.method_25368() + OptionsListWidget.this.rowGap;
            }

            this.button.method_48229(right - this.button.method_25368(), this.method_46427());
            this.renderLabel(guiGraphics);
            super.method_25343(guiGraphics, mouseX, mouseY, hovered, partialTick);
        }
    }

    private class ToggleableSliderEntry extends ToggleEntry {
        private final SliderWidget slider;

        private ToggleableSliderEntry(
                @NotNull SliderWidget slider,
                boolean value,
                @NotNull Consumer<Boolean> onToggle,
                @Nullable class_7919 tooltip,
                boolean active
        ) {
            super(value, onToggle, slider.method_25369(), null, tooltip, active);

            this.slider = slider;
            this.slider.field_22763 = value;
            this.addChild(this.slider);
        }

        @Override
        protected void onPress(class_4185 button) {
            super.onPress(button);
            this.slider.field_22763 = this.value;
        }

        @Override
        protected void renderLabel(@NotNull class_332 guiGraphics) {
            // remove label
        }

        @Override
        public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            this.slider.method_25358(field_22758 - BUTTON_WIDTH - OptionsListWidget.this.rowGap);
            this.slider.method_48229(this.method_46426(), this.method_46427());
            this.slider.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            super.method_25343(guiGraphics, mouseX, mouseY, hovered, partialTick);
        }
    }

    @FunctionalInterface
    public interface Prefix {
        /**
         * @return width of prefix
         */
        int render(@NotNull class_332 guiGraphics, class_327 font, int x, int y, int height);
    }
}