package io.github.fishstiz.cursors_extended.mixin.cursorprovider.menus;

import io.github.fishstiz.cursors_extended.cursor.CursorProvider;
import io.github.fishstiz.cursors_extended.cursor.CursorTypesExt;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_465;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.*;

import static io.github.fishstiz.cursors_extended.CursorsExtended.CONFIG;

@Mixin(class_465.class)
public abstract class AbstractContainerScreenMixin<T extends class_1703> extends class_437 implements CursorProvider {
    @Shadow
    @Final
    protected T menu;

    @Shadow
    @Nullable
    protected class_1735 hoveredSlot;

    protected AbstractContainerScreenMixin(class_2561 title) {
        super(title);
    }

    @Override
    public class_11875 cursors_extended$cursorType(double mouseX, double mouseY) {
        if (menu.method_34255().method_7960() &&
            hoveredSlot != null &&
            hoveredSlot.method_7681() &&
            hoveredSlot.method_51306()) {
            if (CursorTypeUtil.canShift()) {
                return CursorTypesExt.SHIFT;
            }
            if (CONFIG.isItemSlotEnabled()) {
                return class_11876.field_62455;
            }
        }
        if (CONFIG.isItemGrabbingEnabled() && !menu.method_34255().method_7960()) {
            return CursorTypesExt.GRABBING;
        }
        return class_11875.field_62449;
    }
}
