/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.compat;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.compat.CursorStateTracker;
import io.github.fishstiz.cursors_extended.compat.ModCursor;
import io.github.fishstiz.cursors_extended.compat.ModCursorState;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.class_11875;
import org.jetbrains.annotations.Nullable;

class CursorStateTrackerImpl
implements CursorStateTracker {
    private static volatile boolean tracking = false;
    private final Map<Long, ModCursor> cursors = new Long2ObjectOpenHashMap();
    private final Map<Long, Map<String, ModCursorState>> states = new Long2ObjectOpenHashMap();

    CursorStateTrackerImpl() {
    }

    static CursorStateTracker get() {
        return Holder.INSTANCE;
    }

    static CursorStateTracker getOrDefault() {
        return !tracking ? CursorStateTracker.DEFAULT : Holder.INSTANCE;
    }

    static StackWalker getStackWalker() {
        return Holder.STACK_WALKER;
    }

    @Override
    public void trackCursor(ModCursor modCursor) {
        this.cursors.put(modCursor.handle(), modCursor);
    }

    @Override
    public void untrackCursor(ModCursor modCursor) {
        this.cursors.remove(modCursor.handle());
    }

    @Override
    public boolean isTracking() {
        return true;
    }

    @Override
    @Nullable
    public ModCursor getCursor(long handle) {
        return this.cursors.get(handle);
    }

    private void setCursor(String source, long window, class_11875 cursorType, boolean custom) {
        Map windowStates = this.states.computeIfAbsent(window, k -> new Object2ObjectOpenHashMap());
        ModCursorState state = (ModCursorState)windowStates.get(source);
        if (state == null) {
            windowStates.put(source, new ModCursorState(cursorType, custom));
            CursorsExtended.LOGGER.info("[cursors_extended] Tracking cursor state from '{}'", (Object)source);
        } else {
            state.update(cursorType, custom);
        }
    }

    @Override
    public void resetCursor(long window, String source) {
        this.setCursor(source, window, class_11875.field_62449, false);
    }

    @Override
    public void setCursor(long window, ModCursor cursor) {
        this.setCursor(cursor.source(), window, cursor.cursorType(), cursor.custom());
    }

    private boolean shouldReplaceState(ModCursorState current, ModCursorState other) {
        if (current == null) {
            return true;
        }
        boolean isCurrentCustom = current.isCustom();
        boolean isOtherCustom = other.isCustom();
        if (isOtherCustom != isCurrentCustom) {
            return isOtherCustom;
        }
        if (isCurrentCustom) {
            return other.getTimestamp() > current.getTimestamp();
        }
        if (!CursorTypeUtil.nonDefault(other.getCursorType()) == !CursorTypeUtil.nonDefault(current.getCursorType())) {
            return !CursorTypeUtil.nonDefault(other.getCursorType());
        }
        return other.getTimestamp() > current.getTimestamp();
    }

    @Override
    public class_11875 getCurrentCursor(long window) {
        Map<String, ModCursorState> windowStates = this.states.get(window);
        if (windowStates == null || windowStates.isEmpty()) {
            return class_11875.field_62449;
        }
        ModCursorState latestState = null;
        for (ModCursorState state : windowStates.values()) {
            if (!this.shouldReplaceState(latestState, state)) continue;
            latestState = state;
        }
        return latestState == null ? class_11875.field_62449 : latestState.getCursorType();
    }

    private static class Holder {
        static final StackWalker STACK_WALKER = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
        static final CursorStateTracker INSTANCE = new CursorStateTrackerImpl();

        private Holder() {
        }

        static {
            tracking = true;
            CursorsExtended.LOGGER.info("[cursors_extended] Found mod creating its own cursors outside the vanilla API. Initialized cursor state tracker.");
        }
    }
}

