/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.cursor;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorProvider;
import io.github.fishstiz.cursors_extended.cursor.CursorRegistry;
import io.github.fishstiz.cursors_extended.cursor.CursorRenderer;
import io.github.fishstiz.cursors_extended.cursor.debug.CursorDebugRenderer;
import io.github.fishstiz.cursors_extended.lifecycle.ClientStartedListener;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import net.minecraft.class_1041;
import net.minecraft.class_11875;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;

public class CursorDisplay
implements ClientStartedListener {
    private final CursorRegistry registry;
    private class_310 minecraft;
    private CursorDebugRenderer debugRenderer = CursorDebugRenderer.NOP;
    private CursorRenderer cursorRenderer;
    @Nullable
    private class_437 visibleScreen;

    public CursorDisplay(CursorRegistry registry) {
        this.registry = registry;
        this.cursorRenderer = new CursorRenderer.Native(registry);
    }

    @Override
    public void onClientStarted(class_310 minecraft) {
        this.minecraft = minecraft;
        if (CursorsExtended.CONFIG.isVirtualMode() != this.isVirtual()) {
            this.toggleVirtual();
        }
    }

    public class_11875 getCursorAt(class_1041 window) {
        class_437 screen = this.getVisibleScreen();
        if (screen != null) {
            double mouseX = this.minecraft.field_1729.method_68879(window);
            double mouseY = this.minecraft.field_1729.method_68883(window);
            return this.getCursorAt((class_364)screen, mouseX, mouseY);
        }
        return class_11875.field_62449;
    }

    public class_11875 getCursorAt(class_364 element, double mouseX, double mouseY) {
        if (CursorTypeUtil.isHovered(element, mouseX, mouseY)) {
            if (element instanceof class_4069) {
                class_4069 container = (class_4069)element;
                for (class_364 child : container.method_25396()) {
                    class_11875 cursorType = this.getCursorAt(child, mouseX, mouseY);
                    if (!CursorTypeUtil.nonDefault(cursorType)) continue;
                    return cursorType;
                }
            }
            if (element instanceof CursorProvider) {
                CursorProvider provider = (CursorProvider)element;
                this.debugRenderer.setLastCursorAt(element, mouseX, mouseY);
                return provider.cursors_extended$cursorType(mouseX, mouseY);
            }
            this.debugRenderer.setLastCursorAt(element, mouseX, mouseY);
        }
        return class_11875.field_62449;
    }

    public void setVisibleScreen(@Nullable class_437 visibleScreen) {
        this.visibleScreen = visibleScreen;
    }

    @Nullable
    public class_437 getVisibleScreen() {
        class_437 screen = this.minecraft.field_1755;
        return screen != null ? screen : this.visibleScreen;
    }

    public void toggleVirtual() {
        this.cursorRenderer.resetCursor(this.minecraft.method_22683());
        this.cursorRenderer = this.isVirtual() ? new CursorRenderer.Native(this.registry) : new CursorRenderer.Virtual(this.registry);
        this.cursorRenderer.applyCursor(this.minecraft.method_22683());
    }

    public void renderCursor(class_1041 window, class_332 guiGraphics, int mouseX, int mouseY) {
        this.cursorRenderer.render(window, this.minecraft, guiGraphics, mouseX, mouseY);
    }

    public boolean isVirtual() {
        return this.cursorRenderer instanceof CursorRenderer.Virtual;
    }

    public void toggleDebugger() {
        this.debugRenderer = this.debugRenderer.isActive() ? CursorDebugRenderer.NOP : CursorDebugRenderer.create();
    }

    public void renderDebugger(class_332 guiGraphics, int mouseX, int mouseY) {
        this.debugRenderer.render(this.minecraft, this::getVisibleScreen, guiGraphics, mouseX, mouseY);
    }

    public boolean isDebugging() {
        return this.debugRenderer.isActive();
    }

    public void applyCursor(class_1041 window) {
        this.cursorRenderer.applyCursor(window);
    }

    public Cursor getDisplayedCursor(class_1041 window) {
        return this.cursorRenderer.getCurrentCursor(window);
    }

    public Cursor getDisplayedCursor() {
        return this.getDisplayedCursor(this.minecraft.method_22683());
    }

    public class_1041 getWindow() {
        return this.minecraft.method_22683();
    }
}

