/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.screen.panel;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.config.Config;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.gui.MouseEvent;
import io.github.fishstiz.cursors_extended.gui.screen.CatalogItem;
import io.github.fishstiz.cursors_extended.gui.screen.panel.AbstractOptionsPanel;
import io.github.fishstiz.cursors_extended.gui.widget.AbstractListWidget;
import io.github.fishstiz.cursors_extended.gui.widget.ButtonWidget;
import io.github.fishstiz.cursors_extended.gui.widget.CursorHotspotWidget;
import io.github.fishstiz.cursors_extended.gui.widget.CursorPreviewWidget;
import io.github.fishstiz.cursors_extended.gui.widget.ElementSlidingBackground;
import io.github.fishstiz.cursors_extended.gui.widget.InactiveInfoWidget;
import io.github.fishstiz.cursors_extended.gui.widget.SliderWidget;
import io.github.fishstiz.cursors_extended.gui.widget.ToggleWidget;
import io.github.fishstiz.cursors_extended.resource.texture.AnimatedCursorTexture;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_11875;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_7845;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8133;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CursorOptionsPanel
extends AbstractOptionsPanel {
    private static final class_2561 HOTSPOT_GUIDE_TEXT = class_2561.method_43471((String)"cursors_extended.options.hotspot-guide");
    private static final class_2561 ANIMATE_TEXT = class_2561.method_43471((String)"cursors_extended.options.animate");
    private static final class_2561 RESET_ANIMATION_TEXT = class_2561.method_43471((String)"cursors_extended.options.animate-reset");
    private static final class_2561 RESET_DEFAULTS_TEXT = class_2561.method_43471((String)"cursors_extended.options.reset-defaults");
    private static final class_7919 GLOBAL_SCALE_TOOLTIP = CursorOptionsPanel.createGlobalTooltip(SCALE_TEXT);
    private static final class_7919 GLOBAL_XHOT_TOOLTIP = CursorOptionsPanel.createGlobalTooltip(XHOT_TEXT);
    private static final class_7919 GLOBAL_YHOT_TOOLTIP = CursorOptionsPanel.createGlobalTooltip(YHOT_TEXT);
    private static final int CELL_SIZE_STEP = 32;
    private final Runnable refreshCursors;
    private final CatalogItem globalOptions;
    private final Config.CursorSettings settings;
    private final Cursor cursor;
    private class_7845 layout;
    private OptionsList optionsList;
    private SliderWidget scaleSlider;
    private ButtonWidget guiScaleButton;
    private SliderWidget xhotSlider;
    private SliderWidget yhotSlider;
    private ButtonWidget resetToDefaultsButton;
    private CursorHotspotWidget hotspotWidget;
    private CursorPreviewWidget previewWidget;
    private ToggleWidget hotspotGuideToggler;
    private boolean scaling = false;

    public CursorOptionsPanel(Runnable refreshCursors, CatalogItem globalOptions, Cursor cursor) {
        super((class_2561)class_2561.method_43469((String)"cursors_extended.options.cursor-type", (Object[])new Object[]{cursor.text()}));
        this.refreshCursors = refreshCursors;
        this.globalOptions = globalOptions;
        this.settings = CursorsExtended.CONFIG.getOrCreateSettings(cursor);
        this.cursor = cursor;
    }

    @Override
    protected void initContents() {
        boolean row = false;
        int column = 0;
        this.layout = new class_7845().method_48637(this.getSpacing());
        this.layout.method_46452(this.setupFirstColumnWidgets(), 0, column);
        this.layout.method_46452(this.setupSecondColumnWidgets(), 0, ++column);
        this.layout.method_48206(x$0 -> this.addRenderableWidget(x$0));
    }

    @NotNull
    private class_8021 setupFirstColumnWidgets() {
        this.optionsList = new OptionsList(this.getMinecraft(), 20, this.getSpacing());
        this.optionsList.addOption(new ToggleWidget(this.cursor.isTextureEnabled(), ENABLE_TEXT, this::onToggleEnable));
        if (this.cursor.getTexture() != null) {
            this.scaleSlider = this.optionsList.addOption(new SliderWidget(SettingsUtil.sanitizeScale(this.settings.scale()), 0.0, 8.0, 0.05f, this::onChangeScale, SCALE_TEXT, class_5244.field_39003, SettingsUtil::getAutoText, this::onScaleMouseEvent), this.bindGlobalInfo(GLOBAL_SCALE_TOOLTIP, CursorsExtended.CONFIG.getGlobal().isScaleActive()));
            this.guiScaleButton = this.optionsList.addOption(new ButtonWidget(GUI_SCALE_TEXT, this::setGuiScale));
            this.xhotSlider = this.optionsList.addOption(new SliderWidget(SettingsUtil.sanitizeXHot(this.settings.xhot(), this.cursor), 0.0, SettingsUtil.getMaxXHot(this.cursor), 1.0, this::onChangeXHot, XHOT_TEXT, HOTSPOT_SUFFIX), this.bindGlobalInfo(GLOBAL_XHOT_TOOLTIP, CursorsExtended.CONFIG.getGlobal().isXHotActive()));
            this.yhotSlider = this.optionsList.addOption(new SliderWidget(SettingsUtil.sanitizeYHot(this.settings.yhot(), this.cursor), 0.0, SettingsUtil.getMaxYHot(this.cursor), 1.0, this::onChangeYHot, YHOT_TEXT, HOTSPOT_SUFFIX), this.bindGlobalInfo(GLOBAL_YHOT_TOOLTIP, CursorsExtended.CONFIG.getGlobal().isYHotActive()));
            this.hotspotGuideToggler = this.optionsList.addOption(new ToggleWidget(CursorsExtended.CONFIG.isShowHotspotGuide(), HOTSPOT_GUIDE_TEXT, this::onToggleGuide));
            CursorTexture cursorTexture = this.cursor.getTexture();
            if (cursorTexture instanceof AnimatedCursorTexture) {
                AnimatedCursorTexture animatedCursor = (AnimatedCursorTexture)cursorTexture;
                this.optionsList.addOption(new ToggleWidget((boolean)animatedCursor.animated(), ANIMATE_TEXT, this::onToggleAnimate));
                this.optionsList.addOption(new ButtonWidget(RESET_ANIMATION_TEXT, this::restartAnimation));
            }
            this.resetToDefaultsButton = this.optionsList.addOption(new ButtonWidget(RESET_DEFAULTS_TEXT, this::resetToDefaults));
            this.refreshGuiScaleButton(this.settings.scale());
            this.refreshDefaultsButton();
        }
        return this.optionsList;
    }

    @NotNull
    private class_8021 setupSecondColumnWidgets() {
        boolean column = false;
        int row = 0;
        class_7845 cursorWidgetsLayout = new class_7845().method_48637(this.getSpacing());
        if (this.cursor.getTexture() != null) {
            this.hotspotWidget = (CursorHotspotWidget)cursorWidgetsLayout.method_46452((class_8021)new CursorHotspotWidget(this.cursor, Objects.requireNonNull(this.xhotSlider), Objects.requireNonNull(this.yhotSlider), this::onHotspotWidgetMouseEvent), row, 0);
            this.hotspotWidget.setRenderRuler(CursorsExtended.CONFIG.isShowHotspotGuide());
            this.previewWidget = (CursorPreviewWidget)cursorWidgetsLayout.method_46452((class_8021)new CursorPreviewWidget(this.cursor, this.getFont()), ++row, 0);
            this.previewWidget.setRenderRuler(CursorsExtended.CONFIG.isShowHotspotGuide());
        }
        return cursorWidgetsLayout;
    }

    @Override
    protected void repositionContents(int x, int y) {
        if (this.layout != null) {
            int cellSize = CursorOptionsPanel.clampCell(this.method_25368() / 2 - this.getSpacing() / 2);
            this.layout.method_48206(widget -> widget.method_25358(cellSize));
            if (this.optionsList != null) {
                this.optionsList.method_53533(this.computeMaxHeight(y));
            }
            if (this.hotspotWidget != null) {
                this.hotspotWidget.method_53533(cellSize);
            }
            this.layout.method_48229(x, y);
            this.layout.method_48222();
            if (this.previewWidget != null) {
                this.previewWidget.method_53533(Math.min(cellSize, this.getBottom() - this.previewWidget.method_46427()));
            }
        }
    }

    private <T extends class_339> Function<T, class_339> bindGlobalInfo(class_7919 tooltip, boolean global) {
        return widget -> {
            if (widget != null && global) {
                widget.field_22763 = false;
                return new InactiveInfoWidget((class_339)widget, tooltip, this::toGlobalOptionsPanel);
            }
            return null;
        };
    }

    private void toGlobalOptionsPanel() {
        this.changeItem(this.globalOptions);
    }

    private void onToggleEnable(ToggleWidget target, boolean enabled) {
        if (!this.cursor.hasTexture() && CursorOptionsPanel.loadCursor(this.cursor)) {
            this.settings.setEnabled(true);
            this.refreshCursors.run();
            return;
        }
        if (this.cursor.hasTexture()) {
            this.settings.setEnabled(enabled);
            this.refreshCursors.run();
        } else {
            target.setValue(false);
        }
    }

    private void onChangeScale(double scale) {
        CursorOptionsPanel.setScale(this.cursor, (float)scale);
        this.settings.setScale((float)scale);
        this.refreshGuiScaleButton(scale);
        this.refreshDefaultsButton();
    }

    private void onChangeXHot(double xhot) {
        CursorOptionsPanel.setXHot(this.cursor, (int)xhot);
        this.settings.setXHot(this.cursor, (int)xhot);
        this.refreshDefaultsButton();
    }

    private void onChangeYHot(double yhot) {
        CursorOptionsPanel.setYHot(this.cursor, (int)yhot);
        this.settings.setYHot(this.cursor, (int)yhot);
        this.refreshDefaultsButton();
    }

    private void onToggleAnimate(boolean animated) {
        CursorTexture cursorTexture = this.cursor.getTexture();
        if (!(cursorTexture instanceof AnimatedCursorTexture)) {
            throw new IllegalStateException("Cursor is not an animated cursor");
        }
        AnimatedCursorTexture animatedCursor = (AnimatedCursorTexture)cursorTexture;
        animatedCursor.setAnimated(animated);
        this.settings.setAnimated(animated);
        this.refreshDefaultsButton();
    }

    private void onToggleGuide(boolean shown) {
        CursorsExtended.CONFIG.setShowHotspotGuide(shown);
        this.hotspotWidget.setRenderRuler(shown);
        this.previewWidget.setRenderRuler(shown);
    }

    private void restartAnimation() {
        CursorTexture cursorTexture = this.cursor.getTexture();
        if (cursorTexture instanceof AnimatedCursorTexture) {
            AnimatedCursorTexture animatedCursor = (AnimatedCursorTexture)cursorTexture;
            animatedCursor.restartAnimation();
        }
    }

    private void setGuiScale(class_4185 target) {
        target.method_25365(false);
        target.field_22763 = false;
        if (this.scaleSlider != null) {
            this.scaleSlider.applyMappedValue(0.0);
            this.method_25395((class_364)this.scaleSlider);
        }
    }

    private void refreshGuiScaleButton(double scale) {
        if (this.guiScaleButton != null) {
            this.guiScaleButton.field_22763 = !SettingsUtil.isAutoScale(scale) && !CursorsExtended.CONFIG.getGlobal().isScaleActive();
        }
    }

    private void refreshDefaultsButton() {
        if (this.resetToDefaultsButton != null && this.cursor.getTexture() != null) {
            this.resetToDefaultsButton.field_22763 = !SettingsUtil.equalSettings(this.cursor.getTexture().metadata().cursor(), this.settings, true);
        }
    }

    private void resetToDefaults() {
        CursorTexture texture = this.cursor.getTexture();
        if (texture == null) {
            return;
        }
        Config.CursorSettings defaults = this.getDefaults();
        this.settings.mergeAll(defaults);
        CursorsExtended.getInstance().getLoader().updateTexture(this.cursor, CursorsExtended.CONFIG.getGlobal().apply(defaults));
        this.refreshCursors.run();
    }

    private Config.CursorSettings getDefaults() {
        Config.CursorSettings defaultSettings = new Config.CursorSettings();
        if (this.cursor.getTexture() != null) {
            defaultSettings.mergeAll(this.cursor.getTexture().metadata().cursor());
        }
        if (CursorsExtended.CONFIG.getGlobal().isScaleActive()) {
            defaultSettings.setScale(this.settings.scale());
        }
        if (CursorsExtended.CONFIG.getGlobal().isXHotActive()) {
            defaultSettings.setXHot(this.cursor, this.settings.xhot());
        }
        if (CursorsExtended.CONFIG.getGlobal().isYHotActive()) {
            defaultSettings.setYHot(this.cursor, this.settings.yhot());
        }
        return defaultSettings;
    }

    private void onScaleMouseEvent(SliderWidget target, MouseEvent mouseEvent, double mappedValue) {
        this.scaling = (mouseEvent.clicked() || mouseEvent.dragged()) && this.cursor.isTextureEnabled();
    }

    private void onHotspotWidgetMouseEvent(CursorHotspotWidget target, MouseEvent mouseEvent, int xhot, int yhot) {
        if (mouseEvent.clicked() || mouseEvent.dragged()) {
            target.setRenderRuler(true);
            CursorsExtended.CONFIG.setShowHotspotGuide(true);
            if (this.hotspotGuideToggler != null) {
                this.hotspotGuideToggler.setValue(true);
            }
        }
    }

    private static int clampCell(int cell) {
        return Math.round((float)cell / 32.0f) * 32;
    }

    private static class_7919 createGlobalTooltip(class_2561 option) {
        return class_7919.method_47407((class_2561)class_2561.method_43469((String)"cursors_extended.options.global.inactive.tooltip", (Object[])new Object[]{option}));
    }

    @Override
    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_11875 cursorType;
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.scaling) {
            guiGraphics.method_74037(CursorTypeUtil.arrowIfDefault(this.cursor.cursorType()));
        } else if (this.hotspotWidget != null && (cursorType = this.hotspotWidget.cursors_extended$cursorType(mouseX, mouseY)) != class_11875.field_62449) {
            guiGraphics.method_74037(cursorType);
        }
    }

    private static class OptionsList
    extends AbstractListWidget<Entry>
    implements class_8133 {
        private static final int BACKGROUND_PADDING_Y = 2;
        private final ElementSlidingBackground hoveredBackground = new ElementSlidingBackground(0x26FFFFFF);

        private OptionsList(class_310 minecraft, int itemHeight, int spacing) {
            super(minecraft, 0, 0, 0, itemHeight, spacing);
        }

        @NotNull
        private <T extends class_339> T addOption(@NotNull T optionWidget, @Nullable Function<T, class_339> decoration) {
            this.method_25321((class_350.class_351)new Entry(this, optionWidget, decoration != null ? decoration.apply(optionWidget) : null));
            return optionWidget;
        }

        @NotNull
        private <T extends class_339> T addOption(@NotNull T optionWidget) {
            return this.addOption(optionWidget, null);
        }

        protected void method_57715(@NotNull class_332 guiGraphics) {
        }

        protected void method_57713(@NotNull class_332 guiGraphics) {
        }

        public void method_48227(@NotNull Consumer<class_8021> visitor) {
            this.method_25396().forEach(visitor);
        }

        public void method_48222() {
            super.method_48222();
            this.clampScrollAmount();
        }

        protected void renderSlidingBackground(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            int paddingX = this.rowGap;
            int minX = this.method_46426() - paddingX;
            int minY = this.method_46427() - 2;
            int maxX = this.method_55442() + 6;
            int maxY = this.method_55443() + 2;
            guiGraphics.method_44379(minX, minY, maxX, maxY);
            Entry entry = (Entry)this.method_25308(mouseX, mouseY);
            if (entry == null) {
                this.hoveredBackground.reset();
            } else {
                int x = entry.method_46426() - paddingX;
                int y = entry.method_46427() - 2;
                int width = entry.method_25368() + paddingX + (this.method_44392() ? 6 : 2);
                int height = entry.method_25364() + 4;
                this.hoveredBackground.render(guiGraphics, x, y, width, height, partialTick);
            }
            guiGraphics.method_44380();
        }

        public void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.renderSlidingBackground(guiGraphics, mouseX, mouseY, partialTick);
            super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        }

        private class Entry
        extends AbstractListWidget.Entry
        implements class_8133 {
            private final List<class_339> children = new ArrayList<class_339>();
            private final class_339 optionWidget;
            private final class_339 decoration;

            private Entry(@NotNull OptionsList optionsList, @Nullable class_339 optionWidget, class_339 decoration) {
                super(optionsList);
                this.optionWidget = optionWidget;
                this.decoration = decoration;
                if (this.decoration != null) {
                    this.children.add(this.decoration);
                }
                this.children.add(this.optionWidget);
            }

            public void method_25343(class_332 guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
                this.optionWidget.method_48229(this.method_46426(), this.method_46427());
                this.optionWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                if (this.decoration != null) {
                    this.decoration.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                }
            }

            @NotNull
            public List<class_339> method_25396() {
                return this.children;
            }

            @NotNull
            public List<? extends class_6379> method_37025() {
                return this.children;
            }

            public void method_48227(@NotNull Consumer<class_8021> visitor) {
                visitor.accept((class_8021)this.optionWidget);
            }

            public void method_48206(@NotNull Consumer<class_339> visitor) {
                visitor.accept(this.optionWidget);
            }

            public void method_48222() {
                this.optionWidget.method_25358(this.method_25368());
            }
        }
    }
}

