/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.mixin.compat.glfw;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.compat.CursorStateTracker;
import io.github.fishstiz.cursors_extended.compat.ModCursor;
import io.github.fishstiz.cursors_extended.compat.glfw.GLFWInternal;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorRegistry;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import java.util.stream.Stream;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GLFW.class}, remap=false)
public abstract class GLFWMixin {
    @Unique
    private static String cursors_extended$getSourcePackage(Stream<StackWalker.StackFrame> frames) {
        return frames.dropWhile(frame -> frame.getDeclaringClass() == GLFW.class).findFirst().map(frame -> frame.getDeclaringClass().getPackageName()).orElse("placeholder");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"glfwCreateStandardCursor"})
    private static long trackStandardCursor(int shape, Operation<Long> original) {
        Class<GLFWInternal> clazz = GLFWInternal.class;
        synchronized (GLFWInternal.class) {
            long handle = (Long)original.call(new Object[]{shape});
            if (GLFWInternal.isReentrantCall()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return handle;
            }
            class_11875 mapped = CursorTypeUtil.mapStandardCursor(shape);
            if (mapped != null) {
                String sourcePackage = CursorStateTracker.getStackWalker().walk(GLFWMixin::cursors_extended$getSourcePackage);
                CursorStateTracker.get().trackCursor(new ModCursor(handle, sourcePackage, mapped));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return handle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"nglfwCreateCursor"})
    private static long trackCustomCursor(long image, int xhot, int yhot, Operation<Long> original) {
        Class<GLFWInternal> clazz = GLFWInternal.class;
        synchronized (GLFWInternal.class) {
            long handle = (Long)original.call(new Object[]{image, xhot, yhot});
            if (GLFWInternal.isReentrantCall()) {
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return handle;
            }
            String sourcePackage = CursorStateTracker.getStackWalker().walk(GLFWMixin::cursors_extended$getSourcePackage);
            CursorStateTracker.get().trackCursor(ModCursor.ofUnknownType(handle, sourcePackage));
            // ** MonitorExit[var5_4] (shouldn't be in output)
            return handle;
        }
    }

    @Inject(method={"glfwDestroyCursor"}, at={@At(value="RETURN")})
    private static void untrackCursor(long cursor, CallbackInfo ci) {
        ModCursor modCursor = CursorStateTracker.get().getCursor(cursor);
        if (modCursor != null) {
            CursorStateTracker.get().untrackCursor(modCursor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WrapMethod(method={"glfwSetCursor"})
    private static void setMappedCursor(long window, long cursor, Operation<Void> original) {
        Class<GLFWInternal> clazz = GLFWInternal.class;
        synchronized (GLFWInternal.class) {
            CursorStateTracker tracker = CursorStateTracker.get();
            if (GLFWInternal.isReentrantCall() || !tracker.isTracking()) {
                original.call(new Object[]{window, cursor});
                // ** MonitorExit[var5_3] (shouldn't be in output)
                return;
            }
            CursorRegistry registry = CursorsExtended.getInstance().getRegistry();
            if (cursor == 0L) {
                tracker.resetCursor(window, CursorStateTracker.getStackWalker().walk(GLFWMixin::cursors_extended$getSourcePackage));
                original.call(new Object[]{window, CursorsExtended.CONFIG.isRemapStandardCursors() ? registry.get(class_11875.field_62449).handle() : 0L});
                CursorStateTracker.syncWithMinecraft(window, class_11875.field_62449);
                // ** MonitorExit[var5_3] (shouldn't be in output)
                return;
            }
            ModCursor modCursor = tracker.getCursor(cursor);
            if (modCursor == null) {
                modCursor = ModCursor.ofUnknownType(cursor, CursorStateTracker.getStackWalker().walk(GLFWMixin::cursors_extended$getSourcePackage));
                tracker.trackCursor(modCursor);
            }
            tracker.setCursor(window, modCursor);
            if (modCursor.custom() || !CursorsExtended.CONFIG.isRemapStandardCursors()) {
                original.call(new Object[]{window, cursor});
                CursorStateTracker.syncWithMinecraft(window, modCursor.cursorType());
                // ** MonitorExit[var5_3] (shouldn't be in output)
                return;
            }
            Cursor mapped = registry.get(modCursor.cursorType());
            if (!mapped.isEnabled()) {
                mapped = registry.get(class_11875.field_62449);
            }
            CursorsExtended.getInstance().getLoader().lazyLoadTexture(mapped);
            original.call(new Object[]{window, mapped.handle()});
            CursorStateTracker.syncWithMinecraft(window, mapped.cursorType());
            // ** MonitorExit[var5_3] (shouldn't be in output)
            return;
        }
    }

    static {
        CursorsExtended.LOGGER.debug("[cursors_extended] Loading CursorTypes: {}", class_11876.class);
    }
}

