/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.platform;

import io.github.fishstiz.cursors_extended.compat.glfw.GLFWInternal;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class FabricMixinConfigPlugin
implements IMixinConfigPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"cursors_extended | Mixin");
    private static final String MIXIN_PACKAGE = "io.github.fishstiz.cursors_extended.mixin";
    private static final String MOD_MENU_MIXIN_PACKAGE = "io.github.fishstiz.cursors_extended.mixin.compat.modmenu";
    private static final String GLFW_INTERNAL_MIXIN_PACKAGE = "io.github.fishstiz.cursors_extended.mixin.compat.glfw.internal";

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.startsWith(MOD_MENU_MIXIN_PACKAGE) && !FabricLoader.getInstance().isModLoaded("modmenu")) {
            return false;
        }
        return !mixinClassName.startsWith(GLFW_INTERNAL_MIXIN_PACKAGE) || GLFWInternal.isEnabled();
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            return null;
        }
        if (FabricLauncherBase.getLauncher().isClassLoaded("org.lwjgl.glfw.GLFW")) {
            GLFWInternal.setEnabled(false);
            LOGGER.warn("[cursors_extended] GLFW has been loaded early, unable to apply compatibility workarounds.");
            return null;
        }
        return List.of("compat.glfw.GLFWMixin");
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

