/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursor.resolver;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.fishstiz.minecraftcursor.cursor.CursorManager;
import io.github.fishstiz.minecraftcursor.cursor.resolver.ElementInspector;
import io.github.fishstiz.minecraftcursor.cursor.resolver.ElementWalker;
import io.github.fishstiz.minecraftcursor.platform.Services;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ElementInspectorImpl
implements ElementInspector {
    private static final float TEXT_SCALE = 0.75f;
    private static final float Z = 2000.0f;
    private final Component screenLabel = Component.literal((String)"S: ").withColor(-13394945);
    private final Component cacheLabel = Component.literal((String)"Cache: ").withColor(-1);
    private final Component deepestLabel = Component.literal((String)"D: ").withColor(-16711936);
    private final Component processedLabel = Component.literal((String)"P: ").withColor(-65536);
    private final Component virtualModeLabel = Component.literal((String)"Virtual Mode: ").withStyle(ChatFormatting.GOLD);
    private Set<Class<?>> cache = new ObjectOpenHashSet();
    private Component cacheText = Component.empty();
    private GuiEventListener processed;
    private String processedName;
    private boolean enabled = true;

    ElementInspectorImpl() {
    }

    @Override
    public boolean isInspecting() {
        return this.enabled;
    }

    @Override
    public void destroy() {
        this.enabled = false;
        this.cache.clear();
        this.cache = null;
        this.cacheText = null;
        this.processed = null;
        this.processedName = null;
    }

    @Override
    public boolean setProcessed(GuiEventListener processed, boolean cached) {
        this.processed = processed;
        this.processedName = this.getClassName(processed);
        if (cached) {
            this.cache.add(processed.getClass());
            this.cacheText = this.cacheLabel.copy().append(String.valueOf(this.cache.size()));
        }
        return true;
    }

    @Override
    public void render(Minecraft minecraft, @NotNull Screen screen, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        if (this.enabled) {
            ScreenRectangle screenRectangle = this.getBounds((GuiEventListener)screen);
            this.renderScreenName(minecraft, screen, screenRectangle, guiGraphics);
            this.renderCacheSize(minecraft, screenRectangle, guiGraphics);
            this.renderProcessed(minecraft, this.renderDeepest(minecraft, screen, guiGraphics, mouseX, mouseY), guiGraphics);
            this.renderVirtualInfo(minecraft, screenRectangle, guiGraphics);
        }
    }

    private ScreenRectangle renderDeepest(Minecraft minecraft, Screen screen, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        GuiEventListener child = ElementWalker.findDeepest((ContainerEventHandler)screen, mouseX, mouseY);
        GuiEventListener inspect = child != null ? child : screen;
        ScreenRectangle bounds = this.getBounds(inspect);
        MutableComponent label = this.deepestLabel.copy().append(this.getClassName(inspect));
        this.renderInfo(minecraft, guiGraphics, bounds, (Component)label, Position.TOP_LEFT, true);
        return bounds;
    }

    private void renderProcessed(Minecraft minecraft, ScreenRectangle container, GuiGraphics guiGraphics) {
        if (this.processed != null) {
            MutableComponent label = this.processedLabel.copy().append(this.processedName);
            ScreenRectangle bounds = this.getBounds(this.processed);
            int index = bounds.top() != container.top() ? 0 : 1;
            this.renderInfo(minecraft, guiGraphics, bounds, (Component)label, Position.TOP_LEFT, index, true);
        }
    }

    private void renderScreenName(Minecraft minecraft, Screen screen, ScreenRectangle bounds, GuiGraphics guiGraphics) {
        MutableComponent label = this.screenLabel.copy().append(this.getClassName((GuiEventListener)screen));
        this.renderInfo(minecraft, guiGraphics, bounds, (Component)label, Position.BOTTOM_RIGHT, false);
    }

    private void renderCacheSize(Minecraft minecraft, ScreenRectangle screenBounds, GuiGraphics guiGraphics) {
        this.renderInfo(minecraft, guiGraphics, screenBounds, this.cacheText, Position.BOTTOM_RIGHT, -1, false);
    }

    private void renderVirtualInfo(Minecraft minecraft, ScreenRectangle screenBounds, GuiGraphics guiGraphics) {
        MutableComponent virtualMode = this.virtualModeLabel.copy().append(CursorManager.INSTANCE.isVirtual() ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF);
        this.renderInfo(minecraft, guiGraphics, screenBounds, (Component)virtualMode, Position.TOP_RIGHT, false);
    }

    private void renderInfo(Minecraft minecraft, GuiGraphics guiGraphics, ScreenRectangle bounds, Component label, Position pos, boolean outline) {
        this.renderInfo(minecraft, guiGraphics, bounds, label, pos, 0, outline);
    }

    private void renderInfo(Minecraft minecraft, GuiGraphics guiGraphics, ScreenRectangle bounds, Component label, Position pos, int index, boolean outline) {
        TextColor textColor = label.getStyle().getColor();
        int color = 0xFF000000 | (textColor != null ? textColor.getValue() : -1);
        int textX = pos.getX(minecraft, bounds, label, 0.75f);
        int textY = pos.getY(minecraft, bounds, index, 0.75f);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 2000.0f);
        if (outline) {
            guiGraphics.renderOutline(bounds.left(), bounds.top(), bounds.width(), bounds.height(), color);
        }
        poseStack.translate(0.75f, 0.75f, 0.0f);
        poseStack.scale(0.75f, 0.75f, 0.0f);
        guiGraphics.drawString(minecraft.font, label, textX, textY, color);
        poseStack.popPose();
    }

    private ScreenRectangle getBounds(@Nullable GuiEventListener element) {
        if (element instanceof LayoutElement) {
            LayoutElement layoutElement = (LayoutElement)element;
            return layoutElement.getRectangle();
        }
        return element != null ? element.getRectangle() : ScreenRectangle.empty();
    }

    private String getClassName(GuiEventListener element) {
        String namespace = Services.PLATFORM.isDevelopmentEnvironment() ? "named" : "intermediary";
        return Services.PLATFORM.unmapClassName(namespace, element.getClass().getName());
    }

    public static enum Position {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

        private static final int PADDING = 2;

        public int getX(Minecraft minecraft, ScreenRectangle bounds, Component text, float scale) {
            int screenWidth = minecraft.getWindow().getGuiScaledWidth();
            int textWidth = minecraft.font.width((FormattedText)text);
            int x = switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 2 -> (int)((float)(bounds.left() + 2) / scale);
                case 1, 3 -> {
                    int unscaledX = bounds.left() + bounds.width() - (int)((float)textWidth * scale) - 2;
                    yield (int)((float)unscaledX / scale);
                }
            };
            if ((float)(x + textWidth) * scale > (float)screenWidth && (x = (int)(((float)screenWidth - (float)textWidth * scale - 2.0f) / scale)) < 0) {
                x = 0;
            }
            return x;
        }

        public int getY(Minecraft minecraft, ScreenRectangle bounds, int index, float scale) {
            int screenHeight = minecraft.getWindow().getGuiScaledHeight();
            Objects.requireNonNull(minecraft.font);
            int textHeight = 9;
            int offsetY = index * textHeight;
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1 -> (int)((float)(bounds.top() + 2 + offsetY) / scale);
                case 2, 3 -> bounds.height() == 0 && bounds.width() == 0 ? (int)((float)(screenHeight - textHeight - 2 - offsetY) / scale) : (int)((float)(bounds.top() - 2 + Math.max(0, bounds.height() - textHeight) + offsetY) / scale);
            };
        }
    }
}

