/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen.panel;

import io.github.fishstiz.minecraftcursor.CursorResourceLoader;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorController;
import io.github.fishstiz.minecraftcursor.config.Config;
import io.github.fishstiz.minecraftcursor.cursor.AnimatedCursor;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.cursor.CursorManager;
import io.github.fishstiz.minecraftcursor.gui.CursorAnimationHelper;
import io.github.fishstiz.minecraftcursor.gui.MouseEvent;
import io.github.fishstiz.minecraftcursor.gui.screen.CatalogItem;
import io.github.fishstiz.minecraftcursor.gui.screen.panel.AbstractOptionsPanel;
import io.github.fishstiz.minecraftcursor.gui.widget.AbstractListWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.ButtonWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorHotspotWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorPreviewWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.ElementSlidingBackground;
import io.github.fishstiz.minecraftcursor.gui.widget.InactiveInfoWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SliderWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.ToggleWidget;
import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.Layout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CursorOptionsPanel
extends AbstractOptionsPanel {
    private static final Component HOTSPOT_GUIDE_TEXT = Component.translatable((String)"minecraft-cursor.options.hotspot-guide");
    private static final Component ANIMATE_TEXT = Component.translatable((String)"minecraft-cursor.options.animate");
    private static final Component RESET_ANIMATION_TEXT = Component.translatable((String)"minecraft-cursor.options.animate-reset");
    private static final Component RESET_DEFAULTS_TEXT = Component.translatable((String)"minecraft-cursor.options.reset-defaults");
    private static final Tooltip GLOBAL_SCALE_TOOLTIP = CursorOptionsPanel.createGlobalTooltip(SCALE_TEXT);
    private static final Tooltip GLOBAL_XHOT_TOOLTIP = CursorOptionsPanel.createGlobalTooltip(XHOT_TEXT);
    private static final Tooltip GLOBAL_YHOT_TOOLTIP = CursorOptionsPanel.createGlobalTooltip(YHOT_TEXT);
    private static final int CELL_SIZE_STEP = 32;
    private static final int SCALE_CURSOR_OVERRIDE = -20;
    private final CursorAnimationHelper animationHelper;
    private final Runnable refreshCursors;
    private final CatalogItem globalOptions;
    @NotNull
    private final Config.Settings settings;
    @NotNull
    private final Cursor cursor;
    private GridLayout layout;
    private OptionsList optionsList;
    private ToggleWidget enableToggler;
    private SliderWidget scaleSlider;
    private ButtonWidget guiScaleButton;
    private SliderWidget xhotSlider;
    private SliderWidget yhotSlider;
    private ButtonWidget resetToDefaultsButton;
    private CursorHotspotWidget hotspotWidget;
    private CursorPreviewWidget previewWidget;
    private ToggleWidget hotspotGuideToggler;

    public CursorOptionsPanel(CursorAnimationHelper animationHelper, Runnable refreshCursors, CatalogItem globalOptions, Cursor cursor) {
        super((Component)Component.translatable((String)"minecraft-cursor.options.cursor-type", (Object[])new Object[]{cursor.getText()}));
        this.animationHelper = animationHelper;
        this.refreshCursors = refreshCursors;
        this.globalOptions = globalOptions;
        this.settings = MinecraftCursor.CONFIG.getOrCreateSettings(cursor);
        this.cursor = cursor;
    }

    @Override
    protected void initContents() {
        boolean row = false;
        int column = 0;
        this.layout = new GridLayout().spacing(this.getSpacing());
        this.layout.addChild(this.setupFirstColumnWidgets(), 0, column);
        this.layout.addChild(this.setupSecondColumnWidgets(), 0, ++column);
        this.layout.visitWidgets(x$0 -> this.addRenderableWidget(x$0));
    }

    @NotNull
    private LayoutElement setupFirstColumnWidgets() {
        this.optionsList = new OptionsList(this.getMinecraft(), 20, this.getSpacing());
        this.enableToggler = this.optionsList.addOption(new ToggleWidget(this.cursor.isLoaded() && this.cursor.isEnabled(), ENABLE_TEXT, this::onToggleEnable));
        if (this.cursor.isLoaded()) {
            this.scaleSlider = this.optionsList.addOption(new SliderWidget(SettingsUtil.sanitizeScale(this.settings.getScale()), 0.0, 8.0, 0.05, this::onChangeScale, SCALE_TEXT, CommonComponents.EMPTY, SettingsUtil::getAutoText, this::onScaleMouseEvent), this.bindGlobalInfo(GLOBAL_SCALE_TOOLTIP, MinecraftCursor.CONFIG.getGlobal().isScaleActive()));
            this.guiScaleButton = this.optionsList.addOption(new ButtonWidget(GUI_SCALE_TEXT, this::setGuiScale));
            this.xhotSlider = this.optionsList.addOption(new SliderWidget(SettingsUtil.sanitizeHotspot(this.settings.getXHot(), this.cursor), 0.0, SettingsUtil.getMaxHotspot(this.cursor), 1.0, this::onChangeXHot, XHOT_TEXT, HOTSPOT_SUFFIX), this.bindGlobalInfo(GLOBAL_XHOT_TOOLTIP, MinecraftCursor.CONFIG.getGlobal().isXHotActive()));
            this.yhotSlider = this.optionsList.addOption(new SliderWidget(SettingsUtil.sanitizeHotspot(this.settings.getYHot(), this.cursor), 0.0, SettingsUtil.getMaxHotspot(this.cursor), 1.0, this::onChangeYHot, YHOT_TEXT, HOTSPOT_SUFFIX), this.bindGlobalInfo(GLOBAL_YHOT_TOOLTIP, MinecraftCursor.CONFIG.getGlobal().isYHotActive()));
            this.hotspotGuideToggler = this.optionsList.addOption(new ToggleWidget(true, HOTSPOT_GUIDE_TEXT, this::onToggleGuide));
            Cursor cursor = this.cursor;
            if (cursor instanceof AnimatedCursor) {
                AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
                this.optionsList.addOption(new ToggleWidget(animatedCursor.isAnimated(), ANIMATE_TEXT, this::onToggleAnimate));
                this.optionsList.addOption(new ButtonWidget(RESET_ANIMATION_TEXT, this::restartAnimation));
            }
            this.resetToDefaultsButton = this.optionsList.addOption(new ButtonWidget(RESET_DEFAULTS_TEXT, this::resetToDefaults));
            this.refreshGuiScaleButton(this.settings.getScale());
            this.refreshDefaultsButton();
        }
        return this.optionsList;
    }

    @NotNull
    private LayoutElement setupSecondColumnWidgets() {
        boolean column = false;
        int row = 0;
        GridLayout cursorWidgetsLayout = new GridLayout().spacing(this.getSpacing());
        if (this.cursor.isLoaded()) {
            this.hotspotWidget = (CursorHotspotWidget)cursorWidgetsLayout.addChild((LayoutElement)new CursorHotspotWidget(this.cursor, this.animationHelper, Objects.requireNonNull(this.xhotSlider), Objects.requireNonNull(this.yhotSlider), this::onHotspotWidgetMouseEvent), row, 0);
            this.previewWidget = (CursorPreviewWidget)cursorWidgetsLayout.addChild((LayoutElement)new CursorPreviewWidget(this.cursor, this.getFont()), ++row, 0);
        }
        return cursorWidgetsLayout;
    }

    @Override
    protected void repositionContents(int x, int y) {
        if (this.layout != null) {
            int cellSize = CursorOptionsPanel.clampCell(this.getWidth() / 2 - this.getSpacing() / 2);
            this.layout.visitWidgets(widget -> widget.setWidth(cellSize));
            if (this.optionsList != null) {
                this.optionsList.setHeight(this.computeMaxHeight(y));
            }
            if (this.hotspotWidget != null) {
                this.hotspotWidget.setHeight(cellSize);
            }
            this.layout.setPosition(x, y);
            this.layout.arrangeElements();
            if (this.previewWidget != null) {
                this.previewWidget.setHeight(Math.min(cellSize, this.getBottom() - this.previewWidget.getY()));
            }
        }
    }

    private <T extends AbstractWidget> Function<T, AbstractWidget> bindGlobalInfo(Tooltip tooltip, boolean global) {
        return widget -> {
            if (widget != null && global) {
                widget.active = false;
                return new InactiveInfoWidget((AbstractWidget)widget, tooltip, this::toGlobalOptionsPanel);
            }
            return null;
        };
    }

    private void toGlobalOptionsPanel() {
        this.changeItem(this.globalOptions);
    }

    private void onToggleEnable(ToggleWidget target, boolean enabled) {
        if (!this.cursor.isLoaded() && this.loadCursor(this.cursor)) {
            Cursor loaded = Objects.requireNonNull(CursorManager.INSTANCE.getCursor(this.cursor.getType()));
            loaded.enable(true);
            this.settings.setEnabled(true);
            this.refreshCursors.run();
            return;
        }
        if (this.cursor.isLoaded()) {
            this.cursor.enable(enabled);
            this.settings.setEnabled(enabled);
            this.refreshCursors.run();
        } else {
            target.setValue(false);
        }
    }

    private void onChangeScale(double scale) {
        this.cursor.setScale(scale);
        this.settings.setScale(scale);
        this.refreshGuiScaleButton(scale);
        this.refreshDefaultsButton();
    }

    private void onChangeXHot(double xhot) {
        this.cursor.setXHot(xhot);
        this.settings.setXHot(this.cursor, (int)xhot);
        this.refreshDefaultsButton();
    }

    private void onChangeYHot(double yhot) {
        this.cursor.setYHot(yhot);
        this.settings.setYHot(this.cursor, (int)yhot);
        this.refreshDefaultsButton();
    }

    private void onToggleAnimate(boolean animated) {
        Cursor cursor = this.cursor;
        if (!(cursor instanceof AnimatedCursor)) {
            throw new IllegalStateException("Cursor is not an animated cursor");
        }
        AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
        animatedCursor.setAnimated(animated);
        this.settings.setAnimated(animated);
        this.refreshDefaultsButton();
    }

    private void onToggleGuide(boolean shown) {
        Objects.requireNonNull(this.hotspotWidget).setRenderRuler(shown);
    }

    private void restartAnimation() {
        Cursor cursor = this.cursor;
        if (cursor instanceof AnimatedCursor) {
            AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
            this.animationHelper.reset(animatedCursor);
        }
    }

    private void setGuiScale(Button target) {
        target.setFocused(false);
        target.active = false;
        if (this.scaleSlider != null) {
            this.scaleSlider.applyMappedValue(0.0);
            this.setFocused((GuiEventListener)this.scaleSlider);
        }
    }

    private void refreshGuiScaleButton(double scale) {
        if (this.guiScaleButton != null) {
            this.guiScaleButton.active = !SettingsUtil.isAutoScale(scale) && !MinecraftCursor.CONFIG.getGlobal().isScaleActive();
        }
    }

    private void refreshDefaultsButton() {
        if (this.resetToDefaultsButton != null) {
            this.resetToDefaultsButton.active = !CursorResourceLoader.isResourceSetting(this.cursor, this.settings);
        }
    }

    private void resetToDefaults() {
        if (CursorResourceLoader.retoreActiveResourceSettings(Objects.requireNonNull(this.cursor))) {
            this.refreshCursors.run();
            if (this.enableToggler != null) {
                this.setFocused((GuiEventListener)this.enableToggler);
            }
        }
    }

    private void onScaleMouseEvent(SliderWidget target, MouseEvent mouseEvent, double mappedValue) {
        if (mouseEvent.clicked() && CursorManager.INSTANCE.isEnabled(this.cursor)) {
            CursorController.getInstance().overrideCursor(this.cursor.getType(), -20);
        } else if (mouseEvent.released()) {
            CursorOptionsPanel.removeScaleOverride();
        }
    }

    private void onHotspotWidgetMouseEvent(CursorHotspotWidget target, MouseEvent mouseEvent, int xhot, int yhot) {
        if (mouseEvent.clicked() || mouseEvent.dragged()) {
            target.setRenderRuler(true);
            if (this.hotspotGuideToggler != null) {
                this.hotspotGuideToggler.setValue(true);
            }
        }
    }

    @Override
    protected void removed() {
        CursorOptionsPanel.removeScaleOverride();
    }

    public static void removeScaleOverride() {
        CursorController.getInstance().removeOverride(-20);
    }

    private static int clampCell(int cell) {
        return Math.round((float)cell / 32.0f) * 32;
    }

    private static Tooltip createGlobalTooltip(Component option) {
        return Tooltip.create((Component)Component.translatable((String)"minecraft-cursor.options.global.inactive.tooltip", (Object[])new Object[]{option}));
    }

    private static class OptionsList
    extends AbstractListWidget<Entry>
    implements Layout {
        private static final int BACKGROUND_PADDING_Y = 2;
        private final ElementSlidingBackground hoveredBackground = new ElementSlidingBackground(0x26FFFFFF);

        private OptionsList(Minecraft minecraft, int itemHeight, int spacing) {
            super(minecraft, 0, 0, 0, itemHeight, spacing);
        }

        @NotNull
        private <T extends AbstractWidget> T addOption(@NotNull T optionWidget, @Nullable Function<T, AbstractWidget> decoration) {
            this.addEntry((AbstractSelectionList.Entry)new Entry(this, optionWidget, decoration != null ? decoration.apply(optionWidget) : null));
            return optionWidget;
        }

        @NotNull
        private <T extends AbstractWidget> T addOption(@NotNull T optionWidget) {
            return this.addOption(optionWidget, null);
        }

        protected void renderListBackground(@NotNull GuiGraphics guiGraphics) {
        }

        protected void renderListSeparators(@NotNull GuiGraphics guiGraphics) {
        }

        public void visitChildren(@NotNull Consumer<LayoutElement> visitor) {
            this.children().forEach(visitor);
        }

        public void arrangeElements() {
            super.arrangeElements();
            this.clampScrollAmount();
        }

        protected void renderSlidingBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            int paddingX = this.rowGap;
            int minX = this.getX() - paddingX;
            int minY = this.getY() - 2;
            int maxX = this.getRight() + 6;
            int maxY = this.getBottom() + 2;
            guiGraphics.enableScissor(minX, minY, maxX, maxY);
            Entry entry = (Entry)this.getEntryAtPosition(mouseX, mouseY);
            if (entry == null) {
                this.hoveredBackground.reset();
            } else {
                int x = entry.getX() - paddingX;
                int y = entry.getY() - 2;
                int width = entry.getWidth() + paddingX + (this.scrollbarVisible() ? 6 : 2);
                int height = entry.getHeight() + 4;
                this.hoveredBackground.render(guiGraphics, x, y, width, height, partialTick);
            }
            guiGraphics.disableScissor();
        }

        public void renderWidget(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.renderSlidingBackground(guiGraphics, mouseX, mouseY, partialTick);
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        }

        private class Entry
        extends AbstractListWidget.Entry
        implements Layout {
            private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
            private final AbstractWidget optionWidget;
            private final AbstractWidget decoration;

            private Entry(@NotNull OptionsList optionsList, @Nullable AbstractWidget optionWidget, AbstractWidget decoration) {
                super(optionsList);
                this.optionWidget = optionWidget;
                this.decoration = decoration;
                if (this.decoration != null) {
                    this.children.add(this.decoration);
                }
                this.children.add(this.optionWidget);
            }

            public void render(@NotNull GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                this.optionWidget.setPosition(left, top);
                this.optionWidget.render(guiGraphics, mouseX, mouseY, partialTick);
                if (this.decoration != null) {
                    this.decoration.render(guiGraphics, mouseX, mouseY, partialTick);
                }
            }

            @NotNull
            public List<AbstractWidget> children() {
                return this.children;
            }

            @NotNull
            public List<? extends NarratableEntry> narratables() {
                return this.children;
            }

            public void setX(int x) {
                this.optionWidget.setX(x);
            }

            public void setY(int y) {
                this.optionWidget.setY(y);
            }

            public void visitChildren(@NotNull Consumer<LayoutElement> visitor) {
                visitor.accept((LayoutElement)this.optionWidget);
            }

            public void visitWidgets(@NotNull Consumer<AbstractWidget> visitor) {
                visitor.accept(this.optionWidget);
            }

            public void arrangeElements() {
                this.optionWidget.setWidth(this.getWidth());
            }
        }
    }
}

