/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor;

import io.github.fishstiz.minecraftcursor.CursorManager;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.config.AnimatedCursorConfig;
import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import io.github.fishstiz.minecraftcursor.config.CursorConfigLoader;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Optional;
import javax.imageio.ImageIO;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;

abstract class AbstractCursorResourceReloadListener {
    private static final String IMG_TYPE = ".png";
    private static final String ANIMATION_TYPE = ".png.mcmeta";
    private static final String CONFIG_PATH = "atlases/cursors.json";
    private static final String CURSORS_DIR = "textures/cursors/";

    protected AbstractCursorResourceReloadListener() {
    }

    public ResourceLocation getId() {
        return ResourceLocation.m_214293_((String)"minecraft-cursor", (String)CURSORS_DIR);
    }

    public void reloadMinecraftCursor(ResourceManager manager) {
        this.loadConfig(manager);
        this.loadCursorTextures(manager);
        CursorManager.INSTANCE.setCurrentCursor(CursorType.DEFAULT);
    }

    private void loadConfig(ResourceManager manager) {
        List configResources = manager.m_213829_(ResourceLocation.m_214293_((String)"minecraft-cursor", (String)CONFIG_PATH));
        if (configResources.isEmpty()) {
            return;
        }
        this.getConfigFromResources(configResources).ifPresent(config -> {
            if (!config.get_hash().equals(MinecraftCursor.CONFIG.get_hash())) {
                MinecraftCursor.LOGGER.info("[minecraft-cursor] New resource pack settings detected, updating config...");
                MinecraftCursor.CONFIG.set_hash(config.get_hash());
                MinecraftCursor.CONFIG.setSettings(config.getSettings());
                MinecraftCursor.CONFIG.getGlobal().setActiveAll(false);
                MinecraftCursor.CONFIG.save();
            }
        });
    }

    private Optional<CursorConfig> getConfigFromResources(List<Resource> configResources) {
        CursorConfig combinedConfig = null;
        for (Resource configResource : configResources) {
            try {
                InputStream stream = configResource.m_215507_();
                try {
                    CursorConfig loadedConfig = CursorConfigLoader.fromStream(stream);
                    if (combinedConfig == null) {
                        combinedConfig = loadedConfig;
                        continue;
                    }
                    combinedConfig.setSettings(loadedConfig.getSettings());
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                MinecraftCursor.LOGGER.error("[minecraft-cursor] Failed to load settings of resource pack '{}'", (Object)configResource.m_215506_());
            }
        }
        return Optional.ofNullable(combinedConfig);
    }

    private void loadCursorTextures(ResourceManager manager) {
        for (CursorType cursorType : CursorManager.INSTANCE.getCursorTypes()) {
            String basePath = CURSORS_DIR + cursorType.getKey();
            this.loadCursorTexture(manager, cursorType, basePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCursorTexture(ResourceManager manager, CursorType cursorType, String basePath) {
        ResourceLocation cursorId = ResourceLocation.m_214293_((String)"minecraft-cursor", (String)(basePath + IMG_TYPE));
        Resource cursorResource = manager.m_213713_(cursorId).orElse(null);
        if (cursorResource == null) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Cursor Type: '{}' not found", (Object)cursorType.getKey());
            return;
        }
        Image image = null;
        try (InputStream cursorStream = cursorResource.m_215507_();){
            image = ImageIO.read(cursorStream);
            if (image == null) {
                MinecraftCursor.LOGGER.error("[minecraft-cursor] Invalid file for cursor type '{}'", (Object)cursorType);
                return;
            }
            AnimatedCursorConfig animation = this.loadAnimationConfig(manager, basePath, cursorResource);
            CursorManager.INSTANCE.loadCursorImage(cursorType, cursorId, (BufferedImage)image, MinecraftCursor.CONFIG.getOrCreateCursorSettings(cursorType), animation);
        }
        catch (IOException e) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Failed to load cursor image for '{}'", (Object)basePath);
        }
        finally {
            if (image != null) {
                image.flush();
            }
        }
    }

    private AnimatedCursorConfig loadAnimationConfig(ResourceManager manager, String basePath, Resource cursorResource) {
        Resource animationResource = manager.m_213713_(ResourceLocation.m_214293_((String)"minecraft-cursor", (String)(basePath + ANIMATION_TYPE))).orElse(null);
        if (animationResource != null && animationResource.m_215506_().equals(cursorResource.m_215506_())) {
            AnimatedCursorConfig animatedCursorConfig;
            block9: {
                InputStream stream = animationResource.m_215507_();
                try {
                    animatedCursorConfig = CursorConfigLoader.getAnimationConfig(stream);
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        MinecraftCursor.LOGGER.error("[minecraft-cursor] Failed to load animation config for '{}'", (Object)basePath);
                    }
                }
                stream.close();
            }
            return animatedCursorConfig;
        }
        return null;
    }
}

