/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorHandler;
import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.api.ElementRegistrar;
import io.github.fishstiz.minecraftcursor.platform.Services;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;

final class CursorTypeResolver
implements ElementRegistrar {
    static final CursorTypeResolver INSTANCE = new CursorTypeResolver();
    private final List<AbstractMap.SimpleImmutableEntry<Class<? extends GuiEventListener>, ElementRegistrar.CursorTypeFunction<? extends GuiEventListener>>> registry = new ArrayList<AbstractMap.SimpleImmutableEntry<Class<? extends GuiEventListener>, ElementRegistrar.CursorTypeFunction<? extends GuiEventListener>>>();
    private final HashMap<String, ElementRegistrar.CursorTypeFunction<? extends GuiEventListener>> cachedRegistry = new HashMap();
    String lastFailedElement;

    private CursorTypeResolver() {
    }

    public <T extends GuiEventListener> void register(CursorHandler<T> cursorHandler) {
        CursorHandler.TargetElement targetElement = cursorHandler.getTargetElement();
        if (targetElement.elementClass().isPresent()) {
            this.register((Class)targetElement.elementClass().get(), (arg_0, arg_1, arg_2) -> cursorHandler.getCursorType(arg_0, arg_1, arg_2));
        } else if (targetElement.fullyQualifiedClassName().isPresent()) {
            this.register((String)targetElement.fullyQualifiedClassName().get(), (arg_0, arg_1, arg_2) -> cursorHandler.getCursorType(arg_0, arg_1, arg_2));
        } else {
            throw new NullPointerException("Could not register cursor handler: " + cursorHandler.getClass().getName() + " - Target Element Class and FQCN not present");
        }
    }

    public <T extends GuiEventListener> void register(String fullyQualifiedClassName, ElementRegistrar.CursorTypeFunction<T> elementToCursorType) {
        try {
            Class<?> elementClass = Class.forName(Services.PLATFORM.mapClassName("intermediary", fullyQualifiedClassName));
            if (!GuiEventListener.class.isAssignableFrom(elementClass)) {
                throw new ClassCastException(fullyQualifiedClassName + " is not a subclass of Element");
            }
            this.register(elementClass, elementToCursorType);
        }
        catch (ClassNotFoundException e) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Error registering element. Class not found: {}", (Object)fullyQualifiedClassName);
        }
        catch (ClassCastException e) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Error registering element. Invalid class: {}", (Object)e.getMessage());
        }
    }

    public <T extends GuiEventListener> void register(Class<T> elementClass, ElementRegistrar.CursorTypeFunction<T> elementToCursorType) {
        this.registry.add(new AbstractMap.SimpleImmutableEntry<Class<T>, ElementRegistrar.CursorTypeFunction<T>>(elementClass, elementToCursorType));
    }

    public <T extends GuiEventListener> CursorType resolve(T element, double mouseX, double mouseY) {
        String elementName = element.getClass().getName();
        try {
            CursorType cursorType;
            CursorProvider cursorProvider;
            CursorType providedCursorType;
            if (element instanceof CursorProvider && (providedCursorType = (cursorProvider = (CursorProvider)element).getCursorType(mouseX, mouseY)) != null && providedCursorType != CursorType.DEFAULT) {
                return providedCursorType;
            }
            ElementRegistrar.CursorTypeFunction<? extends GuiEventListener> cursorTypeFunction = this.cachedRegistry.get(elementName);
            if (cursorTypeFunction == null) {
                cursorTypeFunction = this.resolveFunction(element);
                this.cachedRegistry.put(elementName, cursorTypeFunction);
            }
            return (cursorType = cursorTypeFunction.getCursorType(element, mouseX, mouseY)) != null ? cursorType : CursorType.DEFAULT;
        }
        catch (Exception | LinkageError e) {
            if (!elementName.equals(this.lastFailedElement)) {
                this.lastFailedElement = elementName;
                MinecraftCursor.LOGGER.error("Could not get cursor type for element: {}", (Object)Services.PLATFORM.unmapClassName("named", elementName));
            }
            return CursorType.DEFAULT;
        }
    }

    private ElementRegistrar.CursorTypeFunction<? extends GuiEventListener> resolveFunction(GuiEventListener element) {
        for (int i = this.registry.size() - 1; i >= 0; --i) {
            if (!this.registry.get(i).getKey().isInstance(element)) continue;
            return this.registry.get(i).getValue();
        }
        if (element instanceof ContainerEventHandler) {
            return this::resolveChild;
        }
        return ElementRegistrar::elementToDefault;
    }

    private <T extends ContainerEventHandler> CursorType resolveChild(T parentElement, double mouseX, double mouseY) {
        CursorType cursorType = CursorType.DEFAULT;
        for (GuiEventListener child : parentElement.m_6702_()) {
            if (child instanceof ContainerEventHandler) {
                ContainerEventHandler childParent = (ContainerEventHandler)child;
                CursorType parentCursorType = this.resolveChild(childParent, mouseX, mouseY);
                CursorType cursorType2 = cursorType = parentCursorType != CursorType.DEFAULT ? parentCursorType : cursorType;
            }
            if (!child.m_5953_(mouseX, mouseY)) continue;
            CursorType childCursorType = this.resolve(child, mouseX, mouseY);
            cursorType = childCursorType != CursorType.DEFAULT ? childCursorType : cursorType;
        }
        return cursorType;
    }
}

