/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursorhandler.ingame;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursorhandler.ingame.HandledScreenCursorHandler;
import io.github.fishstiz.minecraftcursor.mixin.access.CreativeInventoryScreenAccessor;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;

public class CreativeInventoryScreenCursorHandler
extends HandledScreenCursorHandler<CreativeModeInventoryScreen.ItemPickerMenu, CreativeModeInventoryScreen> {
    public static final int TAB_WIDTH = 21;
    public static final int TAB_HEIGHT = 27;
    public static final int TAB_OFFSET_X = 3;
    public static final int TAB_OFFSET_Y = 3;

    @Override
    public CursorType getCursorType(CreativeModeInventoryScreen creativeInventoryScreen, double mouseX, double mouseY) {
        CursorType handledScreenCursor = super.getCursorType(creativeInventoryScreen, mouseX, mouseY);
        if (handledScreenCursor != CursorType.DEFAULT) {
            return handledScreenCursor;
        }
        CreativeInventoryScreenAccessor accessor = (CreativeInventoryScreenAccessor)creativeInventoryScreen;
        CursorType cursorType = this.getCursorTypeTabs(accessor, mouseX, mouseY);
        cursorType = cursorType != CursorType.DEFAULT ? cursorType : this.getCursorTypeDelete(accessor);
        return cursorType;
    }

    private CursorType getCursorTypeTabs(CreativeInventoryScreenAccessor creativeInventoryScreen, double mouseX, double mouseY) {
        if (!MinecraftCursor.CONFIG.isCreativeTabsEnabled()) {
            return CursorType.DEFAULT;
        }
        boolean isHovered = false;
        for (CreativeModeTab itemGroup : CreativeModeTabs.m_257388_()) {
            if (!creativeInventoryScreen.invokeIsPointWithinBounds(creativeInventoryScreen.invokeGetTabX(itemGroup) + 3, creativeInventoryScreen.invokeGetTabY(itemGroup) + 3, 21, 27, mouseX, mouseY) || itemGroup == CreativeInventoryScreenAccessor.getSelectedTab()) continue;
            isHovered = true;
            break;
        }
        return isHovered ? CursorType.POINTER : CursorType.DEFAULT;
    }

    private CursorType getCursorTypeDelete(CreativeInventoryScreenAccessor creativeInventoryScreen) {
        Slot focusedSlot = creativeInventoryScreen.getFocusedSlot();
        if (CursorTypeUtil.canShift() && focusedSlot != null && focusedSlot == creativeInventoryScreen.getDeleteItemSlot()) {
            return CursorType.SHIFT;
        }
        return CursorType.DEFAULT;
    }
}

