/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursorhandler.ingame;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursorhandler.ingame.HandledScreenCursorHandler;
import io.github.fishstiz.minecraftcursor.mixin.access.HandledScreenAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.inventory.EnchantmentMenu;

public class EnchantmentScreenCursorHandler
extends HandledScreenCursorHandler<EnchantmentMenu, EnchantmentScreen> {
    public static final int ENCHANTMENT_BTN_WIDTH = 108;
    public static final int ENCHANTMENT_BTN_HEIGHT = 19;
    public static final int ENCHANTMENT_BTN_OFFSET_X = 60;
    public static final int ENCHANTMENT_BTN_OFFSET_Y = 14;

    @Override
    public CursorType getCursorType(EnchantmentScreen enchantmentScreen, double mouseX, double mouseY) {
        CursorType cursorType = super.getCursorType(enchantmentScreen, mouseX, mouseY);
        if (cursorType != CursorType.DEFAULT) {
            return cursorType;
        }
        if (!MinecraftCursor.CONFIG.isEnchantmentsEnabled()) {
            return CursorType.DEFAULT;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return CursorType.DEFAULT;
        }
        HandledScreenAccessor accessor = (HandledScreenAccessor)enchantmentScreen;
        EnchantmentMenu handler = (EnchantmentMenu)accessor.getHandler();
        for (int i = 0; i < handler.f_39446_.length; ++i) {
            boolean isButtonEnabled;
            int enchantmentPower = handler.f_39446_[i];
            boolean bl = isButtonEnabled = enchantmentPower != 0 && (handler.m_39492_() >= i + 1 && player.f_36078_ >= enchantmentPower || player.m_150110_().f_35937_);
            if (!isButtonEnabled) continue;
            int containerX = (enchantmentScreen.f_96543_ - accessor.getBackgroundWidth()) / 2;
            int containerY = (enchantmentScreen.f_96544_ - accessor.getBackgroundHeight()) / 2;
            int buttonX = containerX + 60;
            int buttonY = containerY + 14 + 19 * i;
            int relativeX = (int)mouseX - buttonX;
            int relativeY = (int)mouseY - buttonY;
            if (relativeX < 0 || relativeY < 0 || relativeX >= 108 || relativeY >= 19) continue;
            return CursorType.POINTER;
        }
        return CursorType.DEFAULT;
    }
}

