/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursorhandler.ingame;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.api.cursorhandler.AbstractHandledScreenCursorHandler;
import io.github.fishstiz.minecraftcursor.mixin.access.HandledScreenAccessor;
import io.github.fishstiz.minecraftcursor.provider.HandledScreenCursorProvider;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class HandledScreenCursorHandler<T extends AbstractContainerMenu, U extends AbstractContainerScreen<? extends T>>
extends AbstractHandledScreenCursorHandler<T, U> {
    public CursorType getCursorType(U handledScreen, double mouseX, double mouseY) {
        CursorType cursorType = this.computeCursorType(handledScreen);
        HandledScreenCursorProvider.setCursorType((CursorType)cursorType);
        return cursorType;
    }

    private CursorType computeCursorType(U handledScreen) {
        boolean canClickFocusedSlot;
        Object handler = ((HandledScreenAccessor)handledScreen).getHandler();
        Slot focusedSlot = ((HandledScreenAccessor)handledScreen).getFocusedSlot();
        boolean bl = canClickFocusedSlot = handler.m_142621_().m_41619_() && focusedSlot != null && focusedSlot.m_6657_() && focusedSlot.m_280329_();
        if (canClickFocusedSlot && CursorTypeUtil.canShift()) {
            return CursorType.SHIFT;
        }
        if (MinecraftCursor.CONFIG.isItemSlotEnabled() && canClickFocusedSlot) {
            return CursorType.POINTER;
        }
        if (MinecraftCursor.CONFIG.isItemGrabbingEnabled() && !handler.m_142621_().m_41619_()) {
            return CursorType.GRABBING;
        }
        return CursorType.DEFAULT;
    }
}

