/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursorhandler.ingame;

import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursorhandler.ingame.HandledScreenCursorHandler;
import io.github.fishstiz.minecraftcursor.mixin.access.AbstractFurnaceScreenAccessor;
import io.github.fishstiz.minecraftcursor.mixin.access.CraftingScreenAccessor;
import io.github.fishstiz.minecraftcursor.mixin.access.InventoryScreenAccessor;
import io.github.fishstiz.minecraftcursor.mixin.access.RecipeAlternativesWidgetAccessor;
import io.github.fishstiz.minecraftcursor.mixin.access.RecipeBookResultsAccessor;
import io.github.fishstiz.minecraftcursor.mixin.access.RecipeBookWidgetAccessor;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.AbstractFurnaceScreen;
import net.minecraft.client.gui.screens.inventory.CraftingScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.recipebook.OverlayRecipeComponent;
import net.minecraft.world.inventory.RecipeBookMenu;

public class RecipeBookScreenCursorHandler<T extends AbstractContainerScreen<? extends RecipeBookMenu<?>>>
extends HandledScreenCursorHandler<RecipeBookMenu<?>, T> {
    public static final RecipeBookScreenCursorHandler<InventoryScreen> INVENTORY = new RecipeBookScreenCursorHandler();
    public static final RecipeBookScreenCursorHandler<CraftingScreen> CRAFTING = new RecipeBookScreenCursorHandler();
    public static final RecipeBookScreenCursorHandler<AbstractFurnaceScreen<?>> FURNACE = new RecipeBookScreenCursorHandler();
    private OverlayRecipeComponent alternatesWidget;

    @Override
    public CursorType getCursorType(T recipeBookScreen, double mouseX, double mouseY) {
        CursorType cursorType = super.getCursorType(recipeBookScreen, mouseX, mouseY);
        if (!(cursorType == CursorType.DEFAULT || this.alternatesWidget != null && this.alternatesWidget.m_100212_())) {
            return cursorType;
        }
        RecipeBookWidgetAccessor recipeBook = this.getRecipeBook((AbstractContainerScreen<?>)recipeBookScreen);
        if (recipeBook == null || !recipeBook.invokeIsOpen()) {
            return CursorType.DEFAULT;
        }
        RecipeBookResultsAccessor recipesArea = (RecipeBookResultsAccessor)recipeBook.getRecipesArea();
        this.alternatesWidget = recipesArea.getAlternatesWidget();
        if (this.alternatesWidget.m_100212_()) {
            return this.getAlternatesWidgetCursor((RecipeAlternativesWidgetAccessor)this.alternatesWidget);
        }
        if (recipesArea.getHoveredResultButton() != null && CursorTypeUtil.canShift()) {
            return CursorType.SHIFT;
        }
        if (this.isButtonHovered(recipeBook, recipesArea) || recipesArea.getHoveredResultButton() != null) {
            return CursorType.POINTER;
        }
        if (recipeBook.getSearchField().m_274382_()) {
            return CursorType.TEXT;
        }
        return this.getTabCursor(recipeBook);
    }

    private RecipeBookWidgetAccessor getRecipeBook(AbstractContainerScreen<?> screen) {
        if (screen instanceof InventoryScreen) {
            InventoryScreen inventory = (InventoryScreen)screen;
            return (RecipeBookWidgetAccessor)((InventoryScreenAccessor)inventory).getRecipeBook();
        }
        if (screen instanceof CraftingScreen) {
            CraftingScreen crafting = (CraftingScreen)screen;
            return (RecipeBookWidgetAccessor)((CraftingScreenAccessor)crafting).getRecipeBook();
        }
        if (screen instanceof AbstractFurnaceScreen) {
            AbstractFurnaceScreen furnace = (AbstractFurnaceScreen)screen;
            return (RecipeBookWidgetAccessor)((AbstractFurnaceScreenAccessor)furnace).getRecipeBook();
        }
        return null;
    }

    private CursorType getAlternatesWidgetCursor(RecipeAlternativesWidgetAccessor alternatesWidget) {
        return alternatesWidget.getAlternativeButtons().stream().anyMatch(AbstractWidget::m_274382_) ? (CursorTypeUtil.canShift() ? CursorType.SHIFT : CursorType.POINTER) : CursorType.DEFAULT_FORCE;
    }

    private boolean isButtonHovered(RecipeBookWidgetAccessor recipeBook, RecipeBookResultsAccessor recipesArea) {
        return recipesArea.getPrevPageButton().m_274382_() && recipesArea.getPrevPageButton().f_93624_ || recipesArea.getNextPageButton().m_274382_() && recipesArea.getNextPageButton().f_93624_ || recipeBook.getToggleCraftableButton().m_274382_();
    }

    private CursorType getTabCursor(RecipeBookWidgetAccessor recipeBook) {
        return recipeBook.getTabButtons().stream().anyMatch(btn -> btn.m_274382_() && btn != recipeBook.getCurrentTab()) ? CursorType.POINTER : CursorType.DEFAULT;
    }
}

