/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursorhandler.ingame;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursorhandler.ingame.HandledScreenCursorHandler;
import io.github.fishstiz.minecraftcursor.mixin.access.StonecutterScreenAccessor;
import net.minecraft.client.gui.screens.inventory.StonecutterScreen;
import net.minecraft.world.inventory.StonecutterMenu;

public class StonecutterScreenCursorHandler
extends HandledScreenCursorHandler<StonecutterMenu, StonecutterScreen> {
    public static final int RECIPES_OFFSET_X = 52;
    public static final int RECIPES_OFFSET_Y = 14;
    public static final int RECIPES_SCROLLOFFSET = 12;
    public static final int GRID_SIZE = 4;
    public static final int RECIPE_SLOT_WIDTH = 16;
    public static final int RECIPE_SLOT_HEIGHT = 18;
    public static final int RECIPE_SLOT_HEIGHT_OFFSET = 2;

    @Override
    public CursorType getCursorType(StonecutterScreen stonecutterScreen, double mouseX, double mouseY) {
        int scrollOffset;
        CursorType cursorType = super.getCursorType(stonecutterScreen, mouseX, mouseY);
        if (cursorType != CursorType.DEFAULT) {
            return cursorType;
        }
        if (!MinecraftCursor.CONFIG.isStonecutterRecipesEnabled()) {
            return CursorType.DEFAULT;
        }
        StonecutterScreenAccessor accessor = (StonecutterScreenAccessor)stonecutterScreen;
        StonecutterMenu handler = (StonecutterMenu)accessor.getHandler();
        int recipesX = accessor.getX() + 52;
        int recipesY = accessor.getY() + 14;
        for (int i = scrollOffset = accessor.getScrollOffset(); i < scrollOffset + 12 && i < handler.m_40340_(); ++i) {
            boolean isRecipeHovered;
            int recipeIndex = i - scrollOffset;
            int row = recipeIndex / 4;
            int slotX = recipesX + recipeIndex % 4 * 16;
            int slotY = recipesY + row * 18 + 2;
            boolean bl = isRecipeHovered = mouseX >= (double)slotX && mouseY >= (double)slotY && mouseX < (double)(slotX + 16) && mouseY < (double)(slotY + 18);
            if (i == handler.m_40338_() || !isRecipeHovered) continue;
            return CursorType.POINTER;
        }
        return CursorType.DEFAULT;
    }
}

