/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen;

import io.github.fishstiz.minecraftcursor.CursorManager;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.screen.CursorAnimationHelper;
import io.github.fishstiz.minecraftcursor.gui.screen.MoreOptionsScreen;
import io.github.fishstiz.minecraftcursor.gui.widget.ContainerWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorListWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsHandler;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsWidget;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class CursorOptionsScreen
extends Screen {
    private static final Component TITLE_TEXT = Component.m_237115_((String)"minecraft-cursor.options");
    private static final int CURSORS_COLUMN_WIDTH = 96;
    private static final int SELECTED_CURSOR_COLUMN_WIDTH = 200;
    private static final int COLUMN_GAP = 8;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private final Button moreButton = Button.m_253074_((Component)Component.m_237115_((String)"minecraft-cursor.options.more").m_130946_("..."), btn -> this.toMoreOptions()).m_253136_();
    private final Button doneButton = Button.m_253074_((Component)CommonComponents.f_130655_, btn -> this.m_7379_()).m_253136_();
    public final CursorAnimationHelper animationHelper = new CursorAnimationHelper();
    private final CursorManager cursorManager;
    private final List<Cursor> cursors;
    final Screen previousScreen;
    private Cursor selectedCursor;
    CursorOptionsBody body;

    public CursorOptionsScreen(Screen previousScreen, CursorManager cursorManager) {
        super(TITLE_TEXT);
        this.previousScreen = previousScreen;
        this.cursorManager = cursorManager;
        this.cursors = this.cursorManager.getLoadedCursors();
    }

    protected void m_7856_() {
        this.selectedCursor = this.cursorManager.getLoadedCursors().get(0);
        this.layout.m_269471_((LayoutElement)new StringWidget(this.f_96539_, this.f_96547_));
        this.body = (CursorOptionsBody)this.layout.m_268999_((LayoutElement)new CursorOptionsBody());
        this.layout.m_269281_((LayoutElement)this.moreButton);
        this.layout.m_269281_((LayoutElement)this.doneButton);
        this.layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.m_142416_((GuiEventListener)this.body.cursorsColumn);
        if (this.body != null) {
            this.refreshWidgetPositions();
        }
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.m_88315_(context, mouseX, mouseY, delta);
        this.m_280039_(context);
        this.body.m_88315_(context, mouseX, mouseY, delta);
        this.moreButton.m_88315_(context, mouseX, mouseY, delta);
        this.doneButton.m_88315_(context, mouseX, mouseY, delta);
    }

    protected void refreshWidgetPositions() {
        this.layout.m_264036_();
        int bodyWidth = 304;
        int buttonWidth = bodyWidth / 2 - 4;
        int centerX = this.f_96543_ / 2;
        int gapHalf = 4;
        this.moreButton.m_93674_(buttonWidth);
        this.doneButton.m_93674_(buttonWidth - 2);
        this.moreButton.m_252865_(centerX - buttonWidth - gapHalf);
        this.doneButton.m_252865_(centerX + gapHalf);
        this.body.position();
    }

    public void selectCursor(Cursor cursor) {
        this.updateSelectedCursorConfig();
        this.selectedCursor = cursor;
        if (this.body != null) {
            this.body.selectedCursorColumn.refresh();
        }
    }

    private void updateSelectedCursorConfig() {
        if (this.body != null) {
            this.body.selectedCursorColumn.save();
        }
    }

    public Cursor getSelectedCursor() {
        return this.selectedCursor;
    }

    public List<Cursor> getCursors() {
        return this.cursors;
    }

    public void toMoreOptions() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new MoreOptionsScreen(this, this.cursorManager));
        }
    }

    public void m_7379_() {
        CursorOptionsHandler.removeScaleOverride();
        MinecraftCursor.CONFIG.save();
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.previousScreen);
        }
    }

    public int getContentHeight() {
        return this.f_96544_ - this.layout.m_269355_() - this.layout.m_269040_();
    }

    public class CursorOptionsBody
    extends ContainerWidget {
        public final CursorListWidget cursorsColumn;
        public final CursorOptionsWidget selectedCursorColumn;

        public CursorOptionsBody() {
            super(CursorOptionsScreen.this.layout.m_252754_(), CursorOptionsScreen.this.layout.m_269355_(), CursorOptionsScreen.this.f_96543_, CursorOptionsScreen.this.getContentHeight(), (Component)Component.m_237119_());
            int y = CursorOptionsScreen.this.layout.m_269355_();
            int height = CursorOptionsScreen.this.getContentHeight();
            CursorOptionsScreen screen = CursorOptionsScreen.this;
            this.cursorsColumn = new CursorListWidget(CursorOptionsScreen.this.f_96541_, 96, height, y, y + height, screen);
            this.selectedCursorColumn = new CursorOptionsWidget(this.computedX2(), 200, height, y, screen);
            this.position();
        }

        public boolean m_6050_(double mouseX, double mouseY, double amount) {
            if (this.cursorsColumn.m_5953_(mouseX, mouseY)) {
                return this.cursorsColumn.m_6050_(mouseX, mouseY, amount);
            }
            return super.m_6050_(mouseX, mouseY, amount);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of(this.cursorsColumn, this.selectedCursorColumn);
        }

        public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
            this.cursorsColumn.m_88315_(context, mouseX, mouseY, delta);
            this.selectedCursorColumn.m_88315_(context, mouseX, mouseY, delta);
        }

        public void position() {
            int width = CursorOptionsScreen.this.f_96543_;
            int height = this.m_239019_();
            int y = CursorOptionsScreen.this.layout.m_269355_();
            this.setDimensions(width, height);
            this.m_264152_(0, y);
            this.cursorsColumn.setHeight(height);
            this.selectedCursorColumn.setHeight(height);
            this.cursorsColumn.m_93507_(this.computedX());
            this.selectedCursorColumn.m_252865_(this.computedX2());
        }

        private int computedX() {
            return CursorOptionsScreen.this.f_96543_ / 2 - 152;
        }

        private int computedX2() {
            return this.computedX() + 96 + 8;
        }

        public void setDimensions(int width, int height) {
            this.f_93618_ = width;
            this.f_93619_ = height;
        }

        protected void m_168797_(NarrationElementOutput builder) {
        }

        protected int m_239019_() {
            return CursorOptionsScreen.this.getContentHeight();
        }

        protected double m_239725_() {
            return 0.0;
        }

        protected void m_239197_(GuiGraphics context, int mouseX, int mouseY, float delta) {
            this.m_88315_(context, mouseX, mouseY, delta);
        }
    }
}

