/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen;

import io.github.fishstiz.minecraftcursor.CursorManager;
import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.gui.screen.CursorOptionsScreen;
import io.github.fishstiz.minecraftcursor.gui.widget.MoreOptionsListWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorHotspotWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class MoreOptionsScreen
extends Screen
implements CursorProvider {
    private static final int HOTSPOT_WIDGET_SIZE = 96;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private final Screen previousScreen;
    private final CursorManager cursorManager;
    @Nullable
    private final SelectedCursorHotspotWidget hotspotWidget;
    private final Button doneButton = Button.m_253074_((Component)CommonComponents.f_130655_, btn -> this.m_7379_()).m_253136_();
    private MoreOptionsListWidget list;

    /*
     * Enabled aggressive block sorting
     */
    protected MoreOptionsScreen(Screen previousScreen, CursorManager cursorManager) {
        super((Component)Component.m_237115_((String)"minecraft-cursor.options.more"));
        this.previousScreen = previousScreen;
        this.cursorManager = cursorManager;
        if (previousScreen instanceof CursorOptionsScreen) {
            CursorOptionsScreen optionsScreen = (CursorOptionsScreen)previousScreen;
            if (optionsScreen.body != null) {
                this.hotspotWidget = new SelectedCursorHotspotWidget(96, optionsScreen.body.selectedCursorColumn);
                this.hotspotWidget.f_93624_ = false;
                this.m_7787_((GuiEventListener)this.hotspotWidget);
                return;
            }
        }
        this.hotspotWidget = null;
    }

    protected void m_7856_() {
        this.layout.m_269471_((LayoutElement)new StringWidget(this.f_96539_, this.f_96547_));
        this.list = (MoreOptionsListWidget)this.layout.m_268999_((LayoutElement)new MoreOptionsListWidget(this.f_96541_, this.f_96543_, this.getContentHeight(), this.layout.m_269355_(), this.layout.m_269355_() + this.getContentHeight(), this.cursorManager));
        if (this.hotspotWidget != null) {
            this.hotspotWidget.setChangeEventListener(this.list::handleChangeHotspotWidget);
        }
        this.layout.m_269281_((LayoutElement)this.doneButton);
        this.layout.m_264134_(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        });
        this.m_7787_((GuiEventListener)this.list);
        this.refreshWidgetPositions();
    }

    protected void refreshWidgetPositions() {
        if (this.list != null) {
            this.layout.m_264036_();
            this.list.position(this.f_96543_, this.getContentHeight(), this.layout.m_269355_());
        }
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.m_88315_(context, mouseX, mouseY, delta);
        this.m_280039_(context);
        this.list.m_88315_(context, mouseX, mouseY, delta);
        this.doneButton.m_88315_(context, mouseX, mouseY, delta);
        if (this.hotspotWidget == null) {
            return;
        }
        if (this.list.isEditingHotspot()) {
            int rowGap = this.list.getRowGap();
            int x = this.list.m_5747_() - this.hotspotWidget.m_5711_() - rowGap;
            int y = this.list.getYEntry(1) + rowGap / 2;
            this.hotspotWidget.m_264152_(x, y);
            this.hotspotWidget.f_93624_ = true;
            this.hotspotWidget.f_93623_ = true;
            context.m_280588_(x, this.layout.m_269355_(), this.list.m_5747_(), this.layout.m_269355_() + this.getContentHeight());
            this.hotspotWidget.m_87963_(context, mouseX, mouseY, delta);
            context.m_280618_();
        } else {
            this.hotspotWidget.f_93624_ = false;
            this.hotspotWidget.f_93623_ = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_7379_() {
        this.list.applyConfig();
        if (this.f_96541_ == null) return;
        Screen screen = this.previousScreen;
        if (screen instanceof CursorOptionsScreen) {
            CursorOptionsScreen options = (CursorOptionsScreen)screen;
            if (options.body != null) {
                CursorOptionsScreen optionsScreen = new CursorOptionsScreen(options.previousScreen, this.cursorManager);
                this.f_96541_.m_91152_((Screen)optionsScreen);
                optionsScreen.selectCursor(options.getSelectedCursor());
                return;
            }
        }
        this.f_96541_.m_91152_(this.previousScreen);
    }

    public CursorType getCursorType(double mouseX, double mouseY) {
        int headerHeight = this.layout.m_269355_();
        if ((mouseY < (double)headerHeight || mouseY > (double)(headerHeight + this.getContentHeight())) && mouseX > (double)(this.doneButton.m_252754_() + this.doneButton.m_5711_())) {
            return CursorType.DEFAULT_FORCE;
        }
        return CursorType.DEFAULT;
    }

    public int getContentHeight() {
        return this.f_96544_ - this.layout.m_269355_() - this.layout.m_269040_();
    }
}

