/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.screen.CursorOptionsScreen;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class CursorListWidget
extends ContainerObjectSelectionList<CursorEntry> {
    private static final int ITEM_HEIGHT = 32;
    private static final int SCROLLBAR_OFFSET = 6;
    private static final int ROW_GAP = 1;
    private final CursorOptionsScreen optionsScreen;

    public CursorListWidget(Minecraft client, int width, int height, int y, int bottom, CursorOptionsScreen optionsScreen) {
        super(client, width + 6, height, y, bottom, 33);
        this.optionsScreen = optionsScreen;
        this.f_93390_ = y;
        this.m_93488_(false);
        this.m_93473_(false, 0);
        this.m_93496_(false);
        this.populateEntries();
    }

    public void populateEntries() {
        for (Cursor cursor : this.optionsScreen.getCursors()) {
            CursorEntry entry = new CursorEntry(cursor, this.f_93393_, this.f_93390_ + this.f_93387_ * this.m_5773_(), this.f_93388_ - 6, 32);
            this.m_7085_((AbstractSelectionList.Entry)entry);
        }
    }

    public int m_93518_() {
        return Math.max(0, this.m_5775_() - (this.f_93391_ - this.f_93390_) + 1 * this.m_5773_() - 1);
    }

    protected int m_5756_() {
        return this.f_93393_ + this.f_93388_ - 6;
    }

    public void m_93507_(int leftPos) {
        this.f_93393_ = leftPos;
        super.m_93507_(leftPos);
        this.m_93494_((AbstractSelectionList.Entry)((CursorEntry)this.m_264567_()));
    }

    public void setHeight(int height) {
        this.f_93389_ = height;
    }

    class CursorEntry
    extends ContainerObjectSelectionList.Entry<CursorEntry> {
        public final CursorButtonWidget button;

        public CursorEntry(Cursor cursor, int x, int y, int width, int height) {
            this.button = new CursorButtonWidget(x, y, width, height, cursor);
        }

        public void m_6311_(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            this.button.m_252865_(CursorListWidget.this.f_93393_);
            this.button.m_253211_(CursorListWidget.this.f_93390_ + (CursorListWidget.this.f_93387_ + 1) * index - (int)Math.round(CursorListWidget.this.m_93517_()));
            this.button.m_87963_(context, mouseX, mouseY, delta);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of(this.button);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of(this.button);
        }
    }

    class CursorButtonWidget
    extends AbstractButton
    implements CursorProvider {
        private static final String PREFIX_TEXT_KEY = "minecraft-cursor.options.cursor-type.";
        private static final int TEXTURE_SIZE = 16;
        private static final int PADDING_LEFT = 8;
        private static final int BACKGROUND_COLOR = 0x7F000000;
        private static final int TEXT_COLOR = -1;
        private static final int TEXT_DISABLED_COLOR = -11184811;
        private static final int BORDER_COLOR = -1;
        private final Cursor cursor;

        CursorButtonWidget(int x, int y, int width, int height, Cursor cursor) {
            super(x, y, width, height, (Component)Component.m_237119_());
            this.cursor = cursor;
        }

        public void m_5691_() {
            CursorListWidget.this.optionsScreen.selectCursor(this.cursor);
        }

        public void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
            this.renderBox(context);
            this.renderTexture(context);
            this.renderMessage(context);
            context.m_280637_(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), this.m_5953_(mouseX, mouseY) || this.cursor == CursorListWidget.this.optionsScreen.getSelectedCursor() ? -1 : -16777216);
        }

        private void renderBox(GuiGraphics context) {
            int x2 = this.m_252754_() + this.m_5711_();
            int y2 = this.m_252907_() + this.m_93694_();
            context.m_280509_(this.m_252754_(), this.m_252907_(), x2, y2, 0x7F000000);
        }

        private void renderTexture(GuiGraphics context) {
            int x = this.m_252754_() + 8;
            int y = this.m_252907_() + this.m_93694_() / 2 - 8;
            CursorListWidget.this.optionsScreen.animationHelper.drawSprite(context, this.cursor, x, y, 16);
        }

        private void renderMessage(GuiGraphics context) {
            MutableComponent message = Component.m_237115_((String)(PREFIX_TEXT_KEY + this.cursor.getType().getKey()));
            int color = this.cursor.isEnabled() ? -1 : -11184811;
            int x = this.m_252754_() + 16 + 16;
            int endX = this.m_252754_() + this.m_5711_() - 6;
            int endY = this.m_252907_() + this.m_93694_();
            DrawUtil.drawScrollableTextLeftAlign(context, ((CursorListWidget)CursorListWidget.this).f_93386_.f_91062_, (Component)message, x, this.m_252907_(), endX, endY, color);
        }

        protected void m_168797_(NarrationElementOutput builder) {
        }

        public CursorType getCursorType(double mouseX, double mouseY) {
            return CursorType.POINTER;
        }
    }
}

