/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorClickableWidget;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import io.github.fishstiz.minecraftcursor.util.MouseEvent;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class SelectedCursorHotspotWidget
extends SelectedCursorClickableWidget
implements CursorProvider {
    private static final CursorConfig.GlobalSettings global = MinecraftCursor.CONFIG.getGlobal();
    private static final ResourceLocation BACKGROUND = ResourceLocation.m_214293_((String)"minecraft-cursor", (String)"textures/gui/hotspot_background.png");
    private static final int CURSOR_SIZE = 32;
    private static final int RULER_COLOR = -65536;
    private static final int OVERRIDE_RULER_COLOR = -16711936;
    private final CursorOptionsWidget options;
    private boolean rulerRendered = true;
    private float rulerAlpha = 1.0f;
    private MouseEventListener changeEventListener;

    public SelectedCursorHotspotWidget(int size, CursorOptionsWidget options) {
        super(options.m_252754_(), options.m_252907_(), size, size, (Component)Component.m_237119_());
        this.options = options;
    }

    public void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.m_280163_(BACKGROUND, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
        if (!this.f_93623_) {
            context.m_280509_(this.m_252754_(), this.m_252907_(), this.getRight(), this.getBottom(), -1358954496);
        }
        this.drawCursorTexture(context);
        this.renderRuler(context, mouseX, mouseY);
        context.m_280637_(this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), -16777216);
    }

    private void drawCursorTexture(GuiGraphics context) {
        this.options.parent().animationHelper.drawSprite(context, this.options.parent().getSelectedCursor(), this.m_252754_(), this.m_252907_(), this.f_93618_);
    }

    private void renderRuler(GuiGraphics context, int mouseX, int mouseY) {
        if (this.m_5953_(mouseX, mouseY)) {
            this.setRulerRendered(true, false);
        }
        this.rulerAlpha = Mth.m_14179_((float)0.3f, (float)this.rulerAlpha, (float)(this.rulerRendered ? 1.0f : 0.0f));
        if (this.rulerAlpha <= 0.01f) {
            return;
        }
        boolean isGlobalX = global.isXHotActive();
        boolean isGlobalY = global.isYHotActive();
        int xhot = isGlobalX ? global.getXHot() : (int)this.options.xhotSlider.getTranslatedValue();
        int yhot = isGlobalY ? global.getYHot() : (int)this.options.yhotSlider.getTranslatedValue();
        int rulerSize = this.getRulerSize();
        int xhotX1 = this.m_252754_() + xhot * rulerSize;
        int xhotX2 = this.m_252754_() + xhot * rulerSize + rulerSize;
        int yhotY1 = this.m_252907_() + yhot * rulerSize;
        int yhotY2 = this.m_252907_() + yhot * rulerSize + rulerSize;
        int alpha = (int)(this.rulerAlpha * 255.0f);
        int blendedColorX = this.getBlendedColor(isGlobalX ? -16711936 : -65536, alpha);
        int blendedColorY = this.getBlendedColor(isGlobalY ? -16711936 : -65536, alpha);
        if (isGlobalX && !isGlobalY || isGlobalX == isGlobalY) {
            context.m_280509_(this.m_252754_(), yhotY1, this.getRight(), yhotY2, blendedColorY);
            context.m_280509_(xhotX1, this.m_252907_(), xhotX2, this.getBottom(), blendedColorX);
        } else {
            context.m_280509_(xhotX1, this.m_252907_(), xhotX2, this.getBottom(), blendedColorX);
            context.m_280509_(this.m_252754_(), yhotY1, this.getRight(), yhotY2, blendedColorY);
        }
    }

    public int getBlendedColor(int color, int alpha) {
        return alpha << 24 | color & 0xFFFFFF;
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.setHotspots(MouseEvent.CLICK, mouseX, mouseY);
    }

    protected void m_7212_(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.setHotspots(MouseEvent.DRAG, mouseX, mouseY);
    }

    public void setHotspots(MouseEvent mouseEvent, double mouseX, double mouseY) {
        if (this.changeEventListener != null) {
            int rulerSize = this.getRulerSize();
            int x = ((int)mouseX - this.m_252754_()) / rulerSize;
            int y = ((int)mouseY - this.m_252907_()) / rulerSize;
            this.changeEventListener.onChange(mouseEvent, x, y);
        }
        this.setRulerRendered(true, true);
    }

    private int getRulerSize() {
        return this.m_5711_() / 32;
    }

    public void setRulerRendered(boolean rulerRendered, boolean immediate) {
        if (immediate) {
            this.rulerAlpha = rulerRendered ? 1.0f : 0.0f;
        }
        this.rulerRendered = rulerRendered;
    }

    public CursorType getCursorType(double mouseX, double mouseY) {
        if (!this.f_93623_) {
            return CursorType.DEFAULT;
        }
        if (this.m_93696_() && (CursorTypeUtil.isLeftClickHeld() || CursorTypeUtil.isGrabbing())) {
            return CursorType.GRABBING;
        }
        return CursorType.POINTER;
    }

    public void setChangeEventListener(BiConsumer<Integer, Integer> changeEventListener) {
        this.setChangeEventListener((MouseEvent mouseEvent, int x, int y) -> changeEventListener.accept(x, y));
    }

    public void setChangeEventListener(MouseEventListener changeEventListener) {
        this.changeEventListener = changeEventListener;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return this.f_93624_ && mouseX >= (double)this.m_252754_() && mouseY >= (double)this.m_252907_() && mouseX < (double)this.getRight() && mouseY < (double)this.getBottom();
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.m_93696_()) {
            this.setHotspots(MouseEvent.RELEASE, mouseX, mouseY);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    protected void m_168797_(NarrationElementOutput builder) {
    }

    @FunctionalInterface
    public static interface MouseEventListener {
        public void onChange(MouseEvent var1, int var2, int var3);
    }
}

