/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorButtonWidget;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class SelectedCursorSliderWidget
extends AbstractSliderButton {
    private final Component prefix;
    private final double min;
    private final double max;
    private final double step;
    private final String suffix;
    private final Consumer<Double> onApply;
    @Nullable
    private final Runnable onRelease;
    private double translatedValue;
    private SelectedCursorButtonWidget inactiveHelperButton;
    private boolean held;

    public SelectedCursorSliderWidget(Component text, double defaultValue, double min, double max, double step, Consumer<Double> onApply, Runnable onRelease) {
        this(text, defaultValue, min, max, step, "", onApply, onRelease);
    }

    public SelectedCursorSliderWidget(Component text, double defaultValue, double min, double max, double step, String suffix, Consumer<Double> onApply) {
        this(text, defaultValue, min, max, step, suffix, onApply, null);
    }

    public SelectedCursorSliderWidget(Component text, double defaultValue, double min, double max, double step, String suffix, Consumer<Double> onApply, @Nullable Runnable onRelease) {
        super(0, 0, 0, 0, text, defaultValue);
        this.prefix = text;
        this.min = min;
        this.max = max;
        this.step = step;
        this.suffix = suffix;
        this.onApply = onApply;
        this.onRelease = onRelease;
        this.f_93577_ = this.translatedValueToValue(defaultValue);
        this.translateValue();
        this.m_5695_();
    }

    private double translatedValueToValue(double translatedValue) {
        double clampedValue = Math.max(this.min, Math.min(translatedValue, this.max));
        return (clampedValue - this.min) / (this.max - this.min);
    }

    public void update(double translatedValue, boolean active) {
        this.setTranslatedValue(translatedValue);
        this.f_93623_ = active;
    }

    public void setTranslatedValue(double translatedValue) {
        this.f_93577_ = this.translatedValueToValue(translatedValue);
        this.m_5697_();
        this.m_5695_();
    }

    private void translateValue() {
        double scaledValue = this.min + this.f_93577_ * (this.max - this.min);
        this.translatedValue = (double)Math.round(scaledValue / this.step) * this.step;
    }

    public void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        boolean isHelperButtonPresent;
        SelectedCursorButtonWidget helperButton = this.getInactiveHelperButton();
        boolean bl = isHelperButtonPresent = helperButton != null;
        if (isHelperButtonPresent) {
            boolean bl2 = helperButton.f_93623_ = !this.f_93623_;
        }
        if (isHelperButtonPresent && this.isMouseOverInactive(mouseX, mouseY)) {
            this.renderAroundHelperButton(context, mouseX, mouseY, delta, helperButton);
            helperButton.m_88315_(context, mouseX, mouseY, delta);
        } else {
            super.m_87963_(context, mouseX, mouseY, delta);
        }
        this.f_93622_ = this.m_5953_(mouseX, mouseY);
        if (this.held && !CursorTypeUtil.isLeftClickHeld()) {
            if (this.onRelease != null) {
                this.onRelease.run();
            }
            this.m_93692_(false);
            this.held = false;
        } else {
            this.held = CursorTypeUtil.isLeftClickHeld();
        }
    }

    private void renderAroundHelperButton(GuiGraphics context, int mouseX, int mouseY, float delta, SelectedCursorButtonWidget helperButton) {
        int x = this.m_252754_();
        int y = this.m_252907_();
        int right = x + this.m_5711_();
        int bottom = y + this.m_93694_();
        int helperY = helperButton.m_252907_();
        int helperBottom = helperY + helperButton.m_93694_();
        int helperRight = helperButton.m_252754_() + helperButton.m_5711_();
        this.renderSection(context, mouseX, mouseY, delta, x, y, right, helperY);
        this.renderSection(context, mouseX, mouseY, delta, x, helperBottom, right, bottom);
        this.renderSection(context, mouseX, mouseY, delta, x, helperY, helperButton.m_252754_(), helperBottom);
        this.renderSection(context, mouseX, mouseY, delta, helperRight, helperY, right, helperBottom);
    }

    private void renderSection(GuiGraphics context, int mouseX, int mouseY, float delta, int x1, int y1, int x2, int y2) {
        context.m_280588_(x1, y1, x2, y2);
        super.m_87963_(context, mouseX, mouseY, delta);
        context.m_280618_();
    }

    protected void m_5697_() {
        double previousTranslatedValue = this.translatedValue;
        this.translateValue();
        if (this.m_93696_() && previousTranslatedValue != this.translatedValue) {
            this.onApply.accept(this.translatedValue);
        }
    }

    protected void m_5695_() {
        String formattedValue = String.format(this.step % 1.0 == 0.0 ? "%.0f" : "%.2f", this.translatedValue);
        this.m_93666_((Component)Component.m_237119_().m_7220_(this.prefix).m_7220_(Component.m_130674_((String)(": " + formattedValue + this.suffix))));
    }

    public double getTranslatedValue() {
        return this.translatedValue;
    }

    @Nullable
    public SelectedCursorButtonWidget getInactiveHelperButton() {
        if (this.inactiveHelperButton == null) {
            return null;
        }
        int marginRight = 2;
        int x = this.m_252754_() + this.m_5711_() - this.inactiveHelperButton.m_5711_() - marginRight;
        int y = this.m_252907_() + (this.m_93694_() - this.inactiveHelperButton.m_93694_()) / 2;
        this.inactiveHelperButton.m_264152_(x, y);
        return this.inactiveHelperButton;
    }

    public void setInactiveHelperButton(SelectedCursorButtonWidget helperButton, int width, int height) {
        this.inactiveHelperButton = helperButton;
        this.inactiveHelperButton.m_93674_(width);
        this.inactiveHelperButton.f_93619_ = height;
    }

    public Component getPrefix() {
        return this.prefix;
    }

    public boolean isMouseOverInactive(int mouseX, int mouseY) {
        return !this.f_93623_ && mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.m_5711_() && mouseY < this.m_252907_() + this.m_93694_();
    }
}

