/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.mixin.compat.glfw;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.github.fishstiz.minecraftcursor.CursorManager;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.compat.CursorTracker;
import io.github.fishstiz.minecraftcursor.compat.ExternalCursor;
import io.github.fishstiz.minecraftcursor.compat.ExternalCursorTracker;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={GLFW.class}, remap=false)
public abstract class GlfwMixin {
    @Unique
    private static String minecraft_cursor$getCaller(Stream<StackWalker.StackFrame> frames) {
        return frames.skip(2L).dropWhile(frame -> frame.getDeclaringClass() == GLFW.class).findFirst().map(frame -> frame.getDeclaringClass().getPackageName()).orElse("placeholder");
    }

    @WrapMethod(method={"nglfwCreateCursor"})
    private static long ntrackCustomCursor(long image, int xhot, int yhot, Operation<Long> original) {
        if (ExternalCursorTracker.get().consumeAddress(image)) {
            return (Long)original.call(new Object[]{image, xhot, yhot});
        }
        long id = (Long)original.call(new Object[]{image, xhot, yhot});
        String caller = ExternalCursorTracker.getWalker().walk(GlfwMixin::minecraft_cursor$getCaller);
        ExternalCursorTracker.trackCursor(id, caller.hashCode());
        MinecraftCursor.LOGGER.warn("[minecraft-cursor] Detected custom cursor from '{}'. Expect compatibility issues.", (Object)caller);
        return id;
    }

    @WrapMethod(method={"glfwCreateStandardCursor"})
    private static long mapStandardCursor(int shape, Operation<Long> original) {
        CursorType cursorType;
        long id = (Long)original.call(new Object[]{shape});
        switch (shape) {
            case 221185: {
                CursorType cursorType2 = CursorType.DEFAULT;
                break;
            }
            case 221188: {
                CursorType cursorType2 = CursorType.POINTER;
                break;
            }
            case 221186: {
                CursorType cursorType2 = CursorType.TEXT;
                break;
            }
            case 221187: {
                CursorType cursorType2 = CursorType.CROSSHAIR;
                break;
            }
            case 221189: {
                CursorType cursorType2 = CursorType.RESIZE_EW;
                break;
            }
            case 221190: {
                CursorType cursorType2 = CursorType.RESIZE_NS;
                break;
            }
            case 221191: {
                CursorType cursorType2 = CursorType.RESIZE_NWSE;
                break;
            }
            case 221192: {
                CursorType cursorType2 = CursorType.RESIZE_NESW;
                break;
            }
            case 221193: {
                CursorType cursorType2 = CursorType.GRABBING;
                break;
            }
            case 221194: {
                CursorType cursorType2 = CursorType.NOT_ALLOWED;
                break;
            }
            default: {
                CursorType cursorType2 = cursorType = null;
            }
        }
        if (cursorType != null) {
            ExternalCursor externalCursor = ExternalCursorTracker.get().getTrackedCursor(id);
            if (externalCursor == null) {
                String caller = ExternalCursorTracker.getWalker().walk(GlfwMixin::minecraft_cursor$getCaller);
                MinecraftCursor.LOGGER.info("[minecraft-cursor] Remapping cursor to '{}' from '{}'", (Object)cursorType.getKey(), (Object)caller);
                ExternalCursorTracker.trackCursor(id, caller.hashCode(), cursorType);
            } else {
                externalCursor.update(cursorType);
            }
        }
        return id;
    }

    @WrapMethod(method={"glfwDestroyCursor"})
    private static void removeCursor(long cursor, Operation<Void> original) {
        original.call(new Object[]{cursor});
        ExternalCursorTracker.get().untrackCursor(cursor);
    }

    @WrapMethod(method={"glfwSetCursor"})
    private static void setMinecraftCursor(long window, long cursor, Operation<Void> original) {
        if (!ExternalCursorTracker.isTracking() || window != Minecraft.m_91087_().m_91268_().m_85439_()) {
            original.call(new Object[]{window, cursor});
            return;
        }
        CursorTracker tracker = ExternalCursorTracker.get();
        if (!MinecraftCursor.CONFIG.isRemapCursorsEnabled() || !tracker.isTracking(cursor)) {
            original.call(new Object[]{window, cursor});
            return;
        }
        ExternalCursor externalCursor = tracker.getTrackedCursor(cursor);
        if (externalCursor == null || externalCursor.getCursorType() == ExternalCursor.PLACEHOLDER_CUSTOM || CursorManager.INSTANCE.getCursor(externalCursor.getCursorType()).getId() == 0L) {
            original.call(new Object[]{window, cursor});
            tracker.updateCursor(externalCursor == null ? 0 : externalCursor.getCaller(), ExternalCursor.PLACEHOLDER_CUSTOM);
        } else {
            tracker.updateCursor(externalCursor.getCaller(), externalCursor.getCursorType());
            if (!tracker.isCustom()) {
                original.call(new Object[]{window, CursorManager.INSTANCE.getCurrentCursor().getId()});
            }
        }
    }
}

