package io.github.fishstiz.cursors_extended.compat;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import net.minecraft.class_1041;
import net.minecraft.class_11875;
import org.jspecify.annotations.Nullable;

public sealed interface CursorStateTracker permits CursorStateTrackerImpl, CursorStateTrackerImpl.DefaultTracker {
    void trackCursor(ModCursor cursor);

    void resetCursor(long window, String source);

    void setCursor(long window, ModCursor cursor);

    default void untrackCursor(ModCursor cursor) {
    }

    default boolean isTracking() {
        return false;
    }

    default @Nullable ModCursor getCursor(long handle) {
        return null;
    }

    default class_11875 getCurrentCursor(long window) {
        return class_11875.field_62449;
    }

    static CursorStateTracker get() {
        return CursorStateTrackerImpl.getOrDefault();
    }

    static StackWalker getStackWalker() {
        return CursorStateTrackerImpl.getStackWalker();
    }

    static void syncWithMinecraft(long window, class_11875 cursorType) {
        class_1041 minecraftWindow = CursorsExtended.getInstance().getDisplay().getWindow();
        if (window == minecraftWindow.method_4490()) {
            ((WindowCursor) (Object) minecraftWindow).cursors_extended$setCurrentCursor(cursorType);
        }
    }
}
