package io.github.fishstiz.cursors_extended.cursor;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.jspecify.annotations.Nullable;

import java.util.Map;
import java.util.Set;
import net.minecraft.class_11875;
import net.minecraft.class_11876;

public class CursorRegistry {
    private final Map<String, Cursor> registry = new Object2ObjectLinkedOpenHashMap<>();
    private volatile Map<String, Cursor> external;
    private Map<String, Cursor> custom;

    public void onInitRenderSystem() {
        register(class_11875.field_62449);
        registerAlias(class_11875.field_62449, class_11876.field_62452);
        register(class_11876.field_62455);
        register(CursorTypesExt.GRABBING);
        register(class_11876.field_62453);
        register(CursorTypesExt.SHIFT);
        register(CursorTypesExt.BUSY);
        register(class_11876.field_62459);
        register(class_11876.field_62454);
        register(class_11876.field_62458);
        register(class_11876.field_62457);
        register(class_11876.field_62456);
        register(CursorTypesExt.RESIZE_NWSE);
        register(CursorTypesExt.RESIZE_NESW);
    }

    public void register(class_11875 cursorType) {
        registry.putIfAbsent(cursorType.toString(), new Cursor(cursorType));
    }

    public void registerAlias(class_11875 cursorType, class_11875 alias) {
        registry.putIfAbsent(alias.toString(), get(cursorType));
    }

    public Cursor get(class_11875 cursorType) {
        Cursor cursor = registry.get(cursorType.toString());
        if (cursor != null) return cursor;

        synchronized (this) {
            Map<String, Cursor> map;

            if (((TexturedCursorType) cursorType).cursors_extended$isCustom()) {
                map = this.custom == null ? this.custom = new Object2ObjectOpenHashMap<>() : this.custom;
            } else {
                map = this.external == null ? this.external = new Object2ObjectOpenHashMap<>() : this.external;
            }

            return map.computeIfAbsent(cursorType.toString(), name -> {
                CursorsExtended.LOGGER.info("[cursors_extended] Found external cursor type: {}", cursorType);
                return new Cursor(cursorType);
            });
        }
    }

    public void unregisterCustom(class_11875 cursorType) {
        synchronized (this) {
            if (custom != null) {
                custom.remove(cursorType.toString());
            }
        }
    }

    public @Nullable Cursor tryGet(String cursorType) {
        Cursor cursor = registry.get(cursorType);
        return cursor != null || external == null ? cursor : external.get(cursorType);
    }

    public Set<Cursor> getCursors() {
        Set<Cursor> cursors = new ObjectOpenHashSet<>();
        cursors.addAll(registry.values());
        if (external != null) {
            cursors.addAll(external.values());
        }
        return cursors;
    }

    public Set<Cursor> getInternalCursors() {
        return new ObjectLinkedOpenHashSet<>(registry.values());
    }
}
