package io.github.fishstiz.cursors_extended.gui.screen;

import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

import java.util.Objects;
import java.util.function.UnaryOperator;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_8021;

public record CatalogItem(@NonNull String id, @NonNull class_2561 text, @Nullable Prefix prefix) {
    public CatalogItem {
        Objects.requireNonNull(id);
        Objects.requireNonNull(text);
    }

    public CatalogItem(String id, class_2561 text) {
        this(id, text, null);
    }

    public CatalogItem withPrefix(UnaryOperator<Prefix> prefixModifier) {
        return new CatalogItem(this.id, this.text, prefixModifier.apply(this.prefix));
    }

    public CatalogItem withText(UnaryOperator<class_2561> textModifier) {
        return new CatalogItem(this.id, textModifier.apply(this.text), this.prefix);
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return other instanceof CatalogItem otherItem && otherItem.id().equals(this.id());
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    @FunctionalInterface
    public interface Prefix {
        /**
         * @return width of prefix.
         */
        int render(class_332 guiGraphics, class_327 font, CatalogItem item, class_8021 bounds, int spacing, int mouseX, int mouseY, float partialTick);
    }
}