package io.github.fishstiz.cursors_extended.gui.screen.panel;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.gui.screen.CatalogBrowserScreen;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_370;
import net.minecraft.class_7842;
import org.jspecify.annotations.NonNull;

public abstract class AbstractOptionsPanel extends CatalogBrowserScreen.ContentPanel {
    protected static final class_2561 ENABLE_TEXT = class_2561.method_43471("cursors_extended.options.enabled");
    protected static final class_2561 SCALE_TEXT = class_2561.method_43471("cursors_extended.options.scale");
    protected static final class_2561 GUI_SCALE_TEXT = class_2561.method_43471("cursors_extended.options.scale.gui");
    protected static final class_2561 XHOT_TEXT = class_2561.method_43471("cursors_extended.options.xhot");
    protected static final class_2561 YHOT_TEXT = class_2561.method_43471("cursors_extended.options.yhot");
    protected static final class_2561 HOTSPOT_SUFFIX = class_2561.method_43471("cursors_extended.options.hotspot-suffix");
    private final class_2561 title;
    private class_7842 titleWidget;

    protected AbstractOptionsPanel(class_2561 title) {
        this.title = title.method_27661().method_27692(class_124.field_1067);
    }

    protected abstract void initContents();

    protected abstract void repositionContents(int x, int y);

    @Override
    protected final void init() {
        this.titleWidget = new class_7842(this.title, this.getFont());
        this.addRenderableIndexedWidget(this.titleWidget);
        this.initContents();
    }

    @Override
    protected final void repositionElements() {
        this.titleWidget.method_55445(this.getHeaderWidth(), this.getHeaderHeight());
        this.titleWidget.method_73395(this.getHeaderWidth(), class_7842.class_11764.field_62126);
        this.titleWidget.method_48229(this.method_46426(), this.method_46427());

        this.repositionContents(this.method_46426(), this.method_46427() + this.titleWidget.method_25364() + this.getSpacing());
    }

    protected int computeMaxHeight(int top) {
        return Math.max(0, this.method_25364() - (top - this.method_46427()));
    }

    static boolean loadCursor(@NonNull Cursor deferredCursor) {
        CursorTexture texture = deferredCursor.getTexture();
        if (texture != null) {
            throw new IllegalStateException("Cursor is already loaded");
        }
        if (CursorsExtended.getInstance().getLoader().loadTexture(deferredCursor)) {
            return true;
        }
        class_310.method_1551().method_1566().method_1999(class_370.method_29047(
                class_310.method_1551(),
                class_370.class_9037.field_47585,
                class_2561.method_43471("resourcePack.load_fail"),
                class_2561.method_43469("cursors_extended.options.global.deferred_loading.fail", deferredCursor.text())
        ));
        return false;
    }

    static void setScale(Cursor cursor, float scale) {
        CursorTexture texture = cursor.getTexture();
        if (texture != null) {
            CursorsExtended.getInstance().getLoader().updateTexture(cursor, scale, texture.xhot(), texture.yhot());
        }
    }

    static void setXHot(Cursor cursor, int xhot) {
        CursorTexture texture = cursor.getTexture();
        if (texture != null) {
            CursorsExtended.getInstance().getLoader().updateTexture(cursor, texture.scale(), xhot, texture.yhot());
        }
    }

    static void setYHot(Cursor cursor, int yhot) {
        CursorTexture texture = cursor.getTexture();
        if (texture != null) {
            CursorsExtended.getInstance().getLoader().updateTexture(cursor, texture.scale(), texture.xhot(), yhot);
        }
    }

    protected void refreshWidgets() {
        this.clearWidgets();
        this.init();
    }

    @Override
    protected void added() {
        this.refreshWidgets();
    }
}
