package io.github.fishstiz.cursors_extended.gui.screen.panel;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorTypesExt;
import io.github.fishstiz.cursors_extended.gui.widget.OptionsListWidget;
import io.github.fishstiz.cursors_extended.util.CursorTypeUtil;
import io.github.fishstiz.cursors_extended.util.DrawUtil;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

import java.util.function.Consumer;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_7919;

import static io.github.fishstiz.cursors_extended.CursorsExtended.CONFIG;

public class AdaptiveOptionsPanel extends AbstractOptionsPanel {
    private static final class_7919 ADAPTIVE_INFO = class_7919.method_47407(class_2561.method_43471("cursors_extended.options.adapt.tooltip"));
    private static final class_2561 HOLD_CURSORS = class_2561.method_43471("cursors_extended.options.adapt.hold");
    private static final class_7919 HOLD_CURSORS_INFO = class_7919.method_47407(class_2561.method_43471("cursors_extended.options.adapt.hold.tooltip"));
    private static final class_2561 ITEM_SLOT = class_2561.method_43471("cursors_extended.options.adapt.item_slot");
    private static final class_2561 ITEM_GRAB = class_2561.method_43471("cursors_extended.options.adapt.item_grab");
    private static final class_2561 SCROLLBAR_POINTER = scrollbarText(class_11876.field_62455);
    private static final class_2561 SCROLLBAR_RESIZE = scrollbarText(class_11876.field_62456);
    private static final int CURSOR_SIZE_STEP = 8;
    private final Runnable refreshCursors;
    private OptionsListWidget optionsList;

    public AdaptiveOptionsPanel(class_2561 title, Runnable refreshCursors) {
        super(title);
        this.refreshCursors = refreshCursors;
    }

    @Override
    protected void initContents() {
        this.optionsList = new OptionsListWidget(this.getMinecraft(), this.getFont(), class_4185.field_39501, this.getSpacing());

        this.optionsList.addToggle(isAdaptiveTexturesEnabled(), this::toggleAdaptive, ENABLE_TEXT, ADAPTIVE_INFO, CONFIG.hasResourcePack());
        this.addOption(CONFIG.isHeldCursorsEnabled(), CONFIG::setHeldCursorsEnabled, HOLD_CURSORS, HOLD_CURSORS_INFO, null);
        this.addOption(CONFIG.isItemSlotEnabled(), CONFIG::setItemSlotEnabled, ITEM_SLOT, class_11876.field_62455);
        this.addOption(CONFIG.isItemGrabbingEnabled(), CONFIG::setItemGrabbingEnabled, ITEM_GRAB, CursorTypesExt.GRABBING);
        this.addOption(CONFIG.isPointerScrollbarEnabled(), CONFIG::setPointerScrollbarEnabled, SCROLLBAR_POINTER, class_11876.field_62455);
        this.addOption(CONFIG.isResizeScrollbarEnabled(), CONFIG::setResizeScrollbarEnabled, SCROLLBAR_RESIZE, class_11876.field_62456);

        this.optionsList.search(this.getSearch());

        this.addRenderableWidget(this.optionsList);
    }

    private void addOption(boolean value, Consumer<Boolean> consumer, class_2561 label, class_11875 cursorType) {
        this.addOption(value, consumer, label, null, cursorType);
    }

    private void addOption(boolean value, Consumer<Boolean> consumer, class_2561 label, class_7919 tooltip, class_11875 cursorType) {
        this.optionsList.addToggle(value, consumer, this.index(label), prefixCursor(cursorType), tooltip, true);
    }

    private OptionsListWidget.Prefix prefixCursor(class_11875 cursorType) {
        if (cursorType == null) return null;

        Cursor cursor = CursorsExtended.getInstance().getRegistry().get(cursorType);
        if (!cursor.hasTexture()) return null;

        return (guiGraphics, font, x, y, height) -> {
            int adjustedHeight = height - (height % CURSOR_SIZE_STEP);
            int offsetY = y + (height - adjustedHeight) / 2;
            DrawUtil.drawCursor(guiGraphics, cursor, x, offsetY, adjustedHeight);
            return adjustedHeight;
        };
    }

    @Override
    protected void repositionContents(int x, int y) {
        if (this.optionsList != null) {
            this.optionsList.method_55445(this.method_25368(), this.computeMaxHeight(y));
            this.optionsList.method_48229(x, y);
        }
    }

    @Override
    protected void searched(@NonNull String search, @Nullable class_2561 matched) {
        if (this.optionsList != null) {
            this.optionsList.search(search);
        }
    }

    private void toggleAdaptive(boolean adaptive) {
        for (Cursor cursor : CursorsExtended.getInstance().getRegistry().getInternalCursors()) {
            if (cursor.cursorType() == class_11875.field_62449) continue;

            if (adaptive && cursor.getTexture() == null && CONFIG.hasResourcePack()) {
                loadCursor(cursor);
            }

            CONFIG.getOrCreateSettings(cursor).setEnabled(adaptive);
        }

        this.refreshCursors.run();
        this.refreshWidgets();
        this.repositionElements();
    }

    private boolean isAdaptiveTexturesEnabled() {
        for (Cursor cursor : CursorsExtended.getInstance().getRegistry().getInternalCursors()) {
            if (CursorTypeUtil.nonDefault(cursor.cursorType()) && cursor.isTextureEnabled()) {
                return true;
            }
        }
        return false;
    }

    private static class_2561 scrollbarText(class_11875 cursorType) {
        return class_2561.method_43469("cursors_extended.options.adapt.scrollbar", class_2561.method_43471(
                "cursors_extended.options.cursor-type." + cursorType.toString()
        ));
    }
}
