package io.github.fishstiz.cursors_extended.gui.screen.panel;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.config.Config;
import io.github.fishstiz.cursors_extended.gui.widget.OptionsListWidget;
import net.minecraft.class_2561;
import net.minecraft.class_7919;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

import static io.github.fishstiz.cursors_extended.CursorsExtended.CONFIG;

public class CompatibilityOptionsPanel extends AbstractOptionsPanel {
    private static final class_2561 AGGRESSIVE_TEXT = class_2561.method_43471("cursors_extended.options.compat.aggressive_cursor");
    private static final class_7919 AGGRESSIVE_INFO = class_7919.method_47407(class_2561.method_43471("cursors_extended.options.compat.aggressive_cursor.info"));
    private static final class_2561 VIRTUAL_TEXT = class_2561.method_43471("cursors_extended.options.compat.virtual_mode");
    private static final class_7919 VIRTUAL_INFO = class_7919.method_47407(class_2561.method_43471("cursors_extended.options.compat.virtual_mode.info"));
    private static final class_2561 REMAP_TEXT = class_2561.method_43471("cursors_extended.options.compat.remap_cursors");
    private static final class_7919 REMAP_INFO = class_7919.method_47407(class_2561.method_43471("cursors_extended.options.compat.remap_cursors.info"));
    private static final class_2561 WORKAROUNDS_TEXT = class_2561.method_43471("cursors_extended.options.compat.workarounds");
    private static final class_7919 WORKAROUNDS_INFO = class_7919.method_47407(class_2561.method_43471("cursors_extended.options.compat.workarounds.info"));
    private static final class_2561 LEGACY_MODE_TEXT = class_2561.method_43471("cursors_extended.options.compat.legacy_mode");
    private static final class_7919 LEGACY_MODE_INFO = class_7919.method_47407(class_2561.method_43471("cursors_extended.options.compat.legacy_mode.info"));
    private OptionsListWidget optionsList;

    public CompatibilityOptionsPanel(class_2561 title) {
        super(title);
    }

    @Override
    protected void initContents() {
        this.optionsList = new OptionsListWidget(this.getMinecraft(), this.getFont(), this.getSpacing());

        final Config defaults = Config.defaults();

        this.optionsList.addToggle(
                CONFIG.isWorkaroundsEnabled(),
                defaults.isWorkaroundsEnabled(),
                CONFIG::setWorkarounds,
                this.index(WORKAROUNDS_TEXT),
                WORKAROUNDS_INFO,
                true
        );
        this.optionsList.addToggle(
                CONFIG.isRemapStandardCursors(),
                defaults.isRemapStandardCursors(),
                value -> {
                    CONFIG.setRemapStandardCursors(value);
                    CursorsExtended.getInstance().getDisplay().applyCursor(this.getMinecraft().method_22683());
                },
                this.index(REMAP_TEXT),
                REMAP_INFO,
                CONFIG::isWorkaroundsEnabled
        );
        this.optionsList.addToggle(
                CONFIG.isAggressiveCursor(),
                defaults.isAggressiveCursor(),
                CONFIG::setAggressiveCursor,
                this.index(AGGRESSIVE_TEXT),
                AGGRESSIVE_INFO,
                true
        );
        this.optionsList.addToggle(
                CursorsExtended.getInstance().getDisplay().isVirtual(),
                defaults.isVirtualMode(),
                value -> {
                    CursorsExtended.getInstance().getDisplay().toggleVirtual();
                    CONFIG.setVirtualMode(CursorsExtended.getInstance().getDisplay().isVirtual());
                },
                this.index(VIRTUAL_TEXT),
                VIRTUAL_INFO,
                true
        );
        this.optionsList.addToggle(
                CONFIG.isLegacyMode(),
                defaults.isLegacyMode(),
                CONFIG::setLegacyMode,
                this.index(LEGACY_MODE_TEXT),
                LEGACY_MODE_INFO,
                true
        );

        this.optionsList.search(this.getSearch());

        this.addRenderableWidget(this.optionsList);
    }

    @Override
    protected void repositionContents(int x, int y) {
        if (this.optionsList != null) {
            this.optionsList.method_55445(this.method_25368(), this.computeMaxHeight(y));
            this.optionsList.method_48229(x, y);
        }
    }

    @Override
    protected void searched(@NonNull String search, @Nullable class_2561 matched) {
        if (this.optionsList != null) {
            this.optionsList.search(search);
        }
    }
}
