package io.github.fishstiz.cursors_extended.gui.widget;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.gui.MouseEvent;
import io.github.fishstiz.cursors_extended.util.DrawUtil;
import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5244;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

import static io.github.fishstiz.cursors_extended.CursorsExtended.CONFIG;

public class CursorHotspotWidget extends CursorWidget {
    private static final class_2960 BACKGROUND_128 = CursorsExtended.id("textures/gui/background_128.png");
    private static final int BACKGROUND_DISABLED = 0xAF000000; // 70% black
    private static final int RULER_COLOR = 0xFFFF0000; // red
    private static final int OVERRIDE_RULER_COLOR = 0xFF00FF00; // green
    private static final class_2561 OVERFLOW_TEXT = class_2561.method_43471("cursors_extended.options.image_too_large");
    private static final int OVERFLOW_COLOR = 0xFFFFFFFF; // white
    private final SliderWidget xhotSlider;
    private final SliderWidget yhotSlider;
    private final @Nullable MouseEventListener mouseEventListener;
    private final int maxXHot;
    private final int maxYHot;
    private boolean dragging = false;

    public CursorHotspotWidget(
            @NonNull Cursor cursor,
            @NonNull SliderWidget xhotSlider,
            @NonNull SliderWidget yhotSlider,
            @Nullable MouseEventListener mouseEventListener
    ) {
        super(class_5244.field_39003, cursor, BACKGROUND_128);

        this.xhotSlider = xhotSlider;
        this.yhotSlider = yhotSlider;
        this.mouseEventListener = mouseEventListener;
        this.maxXHot = SettingsUtil.getMaxXHot(cursor);
        this.maxYHot = SettingsUtil.getMaxYHot(cursor);
    }

    @Override
    protected void method_48579(@NonNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.field_22763 = !this.isOverflowing() && (this.xhotSlider.method_37303() || this.yhotSlider.method_37303());
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);

        if (this.method_49606() && this.isOverflowing()) {
            class_327 font = class_310.method_1551().field_1772;
            int textX = this.method_46426() + (this.method_25368() / 2 - font.method_27525(OVERFLOW_TEXT) / 2);
            int textY = this.method_46427() + (this.method_25364() / 2 - font.field_2000 / 2);
            guiGraphics.method_27535(font, OVERFLOW_TEXT, textX, textY, OVERFLOW_COLOR);
        }
    }

    @Override
    protected void renderBackground(@NonNull class_332 guiGraphics) {
        super.renderBackground(guiGraphics);

        if (!this.field_22763) {
            guiGraphics.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), BACKGROUND_DISABLED);
        }
    }

    @Override
    protected void renderCursor(@NonNull class_332 guiGraphics, @NonNull Cursor cursor) {
        DrawUtil.drawCursor(guiGraphics, cursor, this.method_46426(), this.method_46427(), this.method_25368());
    }

    @Override
    protected void renderRuler(@NonNull class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.isOverflowing()) return;

        boolean isGlobalX = CONFIG.getGlobal().isXHotActive();
        boolean isGlobalY = CONFIG.getGlobal().isYHotActive();

        int colorX = isGlobalX ? OVERRIDE_RULER_COLOR : RULER_COLOR;
        int colorY = isGlobalY ? OVERRIDE_RULER_COLOR : RULER_COLOR;

        int xhot = this.clampHotspot(isGlobalX ? CONFIG.getGlobal().xhot() : (int) this.xhotSlider.getMappedValue(), this.maxXHot);
        int yhot = this.clampHotspot(isGlobalY ? CONFIG.getGlobal().yhot() : (int) this.yhotSlider.getMappedValue(), this.maxYHot);

        float rulerWidth = this.getCellWidth();
        float rulerHeight = this.getCellHeight();

        float xhotX1 = (method_46426() + xhot * rulerWidth) - (rulerWidth > 1 || xhot != this.maxXHot ? 0 : 1);
        float xhotX2 = (method_46426() + xhot * rulerWidth) + (xhot > 0 ? rulerWidth : Math.max(rulerWidth, 2));
        float yhotY1 = (method_46427() + yhot * rulerHeight) - (rulerHeight > 1 || yhot != this.maxYHot ? 0 : 1);
        float yhotY2 = (method_46427() + yhot * rulerHeight) + (yhot > 0 ? rulerHeight : Math.max(rulerHeight, 2));


        if ((isGlobalX && !isGlobalY) || (isGlobalX == isGlobalY)) {
            DrawUtil.fill(guiGraphics, this.method_46426(), yhotY1, this.method_55442(), yhotY2, colorY);
            DrawUtil.fill(guiGraphics, xhotX1, this.method_46427(), xhotX2, this.method_55443(), colorX);
        } else {
            DrawUtil.fill(guiGraphics, xhotX1, this.method_46427(), xhotX2, this.method_55443(), colorX);
            DrawUtil.fill(guiGraphics, this.method_46426(), yhotY1, this.method_55442(), yhotY2, colorY);
        }
    }

    @Override
    public void method_25348(class_11909 mouseButtonEvent, boolean doubleClick) {
        this.dragging = true;
        this.setHotspots(MouseEvent.CLICK, mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799());
    }

    @Override
    protected void method_25349(class_11909 mouseButtonEvent, double deltaX, double deltaY) {
        if (this.dragging) {
            this.setHotspots(MouseEvent.DRAG, mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799());
        }
    }

    @Override
    public void method_25357(class_11909 mouseButtonEvent) {
        if (this.dragging) {
            this.dragging = false;
            this.setHotspots(MouseEvent.RELEASE, mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799());
            this.method_25365(false);
        }
    }

    public void setHotspots(MouseEvent mouseEvent, double mouseX, double mouseY) {
        int xhot = this.clampHotspot((int) ((mouseX - this.method_46426()) / this.getCellWidth()), this.maxXHot);
        int yhot = this.clampHotspot((int) ((mouseY - this.method_46427()) / this.getCellHeight()), this.maxYHot);

        if (this.xhotSlider.method_37303()) {
            this.xhotSlider.applyMappedValue(xhot);
        }
        if (this.yhotSlider.method_37303()) {
            this.yhotSlider.applyMappedValue(yhot);
        }
        if (this.mouseEventListener != null) {
            this.mouseEventListener.onMouseEvent(this, mouseEvent, xhot, yhot);
        }
    }

    private int clampHotspot(int hotspot, int max) {
        return SettingsUtil.clamp(hotspot, SettingsUtil.HOT_MIN, max);
    }

    @Override
    public class_11875 cursors_extended$cursorType(double mouseX, double mouseY) {
        if (!this.field_22763) {
            return this.method_49606() ? class_11876.field_62459 : class_11875.field_62449;
        }
        if (!this.dragging) {
            return this.method_49606() ? class_11876.field_62454 : class_11875.field_62449;
        }

        boolean inXHot = !CONFIG.getGlobal().isXHotActive() && this.isInsideXHot(mouseX);
        boolean inYHot = !CONFIG.getGlobal().isYHotActive() && this.isInsideYHot(mouseY);

        if (inXHot && inYHot) {
            return class_11876.field_62458;
        }
        if (inXHot) {
            return class_11876.field_62457;
        }
        if (inYHot) {
            return class_11876.field_62456;
        }
        return class_11876.field_62459;
    }

    private boolean isInsideXHot(double mouseX) {
        double rawX = (mouseX - this.method_46426()) / this.getCellWidth();
        return rawX >= 0 && rawX <= this.maxXHot;
    }

    private boolean isInsideYHot(double mouseY) {
        double rawY = (mouseY - this.method_46427()) / this.getCellHeight();
        return rawY >= 0 && rawY <= this.maxYHot;
    }

    public interface MouseEventListener {
        void onMouseEvent(@NonNull CursorHotspotWidget target, @NonNull MouseEvent mouseEvent, int xhot, int yhot);
    }
}
