package io.github.fishstiz.cursors_extended.gui.widget;

import org.jspecify.annotations.NonNull;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_11907;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_5244;

public class ToggleWidget extends class_4185.class_12231 {
    private final BiConsumer<ToggleWidget, Boolean> listener;
    private final class_2561 prefix;
    private boolean value;

    public ToggleWidget(
            int x,
            int y,
            int width,
            int height,
            boolean value,
            @NonNull class_2561 prefix,
            @NonNull BiConsumer<ToggleWidget, Boolean> listener
    ) {
        super(x, y, width, height, prefix, btn -> {}, field_40754);

        this.listener = listener;
        this.prefix = prefix;

        this.setValue(value);
    }

    public ToggleWidget(boolean value, @NonNull class_2561 prefix, @NonNull BiConsumer<ToggleWidget, Boolean> listener) {
        this(0, 0, field_39500, field_39501, value, prefix, listener);
    }

    public ToggleWidget(boolean value, @NonNull class_2561 prefix, @NonNull Consumer<Boolean> listener) {
        this(0, 0, field_39500, field_39501, value, prefix, (target, v) -> listener.accept(v));
    }

    @Override
    public void method_25306(class_11907 inputWithModifiers) {
        this.value = !this.value;
        this.listener.accept(this, this.value);
        this.updateMessage();
    }

    public void setValue(boolean value) {
        this.value = value;
        this.updateMessage();
    }

    private void updateMessage() {
        this.method_25355(class_5244.method_32700(this.prefix, value ? class_5244.field_24332 : class_5244.field_24333));
    }

    @Override
    public void method_25357(class_11909 mouseButtonEvent) {
        this.method_25365(false);
    }
}
